//
//  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
//  N o t e b o o k   H a r d w a r e   C o n t r o l   A C P I   D L L
//  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
//  for Apple Computers
//
//  This file is provided "as is" with no expressed or implied warranty.
//  The authors accepts no liability for any damage/loss of business that
//  this product may cause.
//
//  Last Update: 07 December 2010
//
public class APPLE
{
    #region INFO: Apple MacBook Pro
    //
    //  MacBookPro1,1     MacBook Pro  15"    Core Duo 1.67MHz      (Early-2006)
    //  MacBookPro1,1     MacBook Pro  15"    Core Duo 1.83MHz      (Early-2006)
    //  MacBookPro1,1     MacBook Pro  15"    Core Duo 2.0MHz       (Early-2006)
    //  MacBookPro1,1     MacBook Pro  15"    Core Duo 2.16MHz      (Early-2006)
    //  MacBookPro1,2     MacBook Pro  17"    Core Duo 2.16MHz      (Early-2006)
    //  MacBookPro2,1     MacBook Pro  17"    Core 2 Duo 2.33MHz    (Late-2006)
    //  MacBookPro2,2     MacBook Pro  15"    Core 2 Duo 2.16MHz    (Late-2006)
    //  MacBookPro2,2     MacBook Pro  15"    Core 2 Duo 2.33MHz    (Late-2006)
    //  MacBookPro3,1     MacBook Pro  15"    Core 2 Duo 2.2MHz     (Mid-2007)
    //  MacBookPro3,1     MacBook Pro  15"    Core 2 Duo 2.4MHz     (Mid-2007)
    //  MacBookPro3,1     MacBook Pro  17"    Core 2 Duo 2.4MHz     (Mid-2007)
    //  MacBookPro4,1     MacBook Pro  15"    Core 2 Duo 2.4MHz     (Early-2008)
    //  MacBookPro4,1     MacBook Pro  15"    Core 2 Duo 2.5MHz     (Early-2008)
    //  MacBookPro4,1     MacBook Pro  17"    Core 2 Duo 2.5MHz     (Early-2008)
    //  MacBookPro5,1     MacBook Pro  15"    Core 2 Duo 2.4MHz     (Late-2008)
    //  MacBookPro5,1     MacBook Pro  15"    Core 2 Duo 2.53MHz    (Late-2008)
    //  MacBookPro5,1     MacBook Pro  15"    Core 2 Duo 2.66MHz    (Early-2009)
    //  MacBookPro5,2     MacBook Pro  17"    Core 2 Duo 2.66MHz    (Early-2009)
    //  MacBookPro5,2     MacBook Pro  17"    Core 2 Duo 2.8MHz     (Mid-2009)
    //  MacBookPro5,3     MacBook Pro  15"    Core 2 Duo 2.66MHz    (Mid-2009)
    //  MacBookPro5,3     MacBook Pro  15"    Core 2 Duo 2.8MHz     (Mid-2009)
    //  MacBookPro5,4     MacBook Pro  15"    Core 2 Duo 2.53MHz    (Mid-2009)
    //  MacBookPro5,5     MacBook Pro  13"    Core 2 Duo 2.26MHz    (Mid-2009)
    //  MacBookPro5,5     MacBook Pro  17"    Core 2 Duo 2.53MHz    (Mid-2009)
    //  MacBookPro6,1     MacBook Pro  17"    Core i5 2.53MHz       (Mid-2010)
    //  MacBookPro6,2     MacBook Pro  15"    Core i5 2.4MHz        (Mid-2010)
    //  MacBookPro6,2     MacBook Pro  15"    Core i5 2.53MHz       (Mid-2010)
    //  MacBookPro6,2     MacBook Pro  15"    Core i7 2.66MHz       (Mid-2010)
    //  MacBookPro7,1     MacBook Pro  13"    Core 2 Duo 2.4MHz     (Mid-2010)
    //  MacBookPro7,1     MacBook Pro  13"    Core 2 Duo 2.66MHz    (Mid-2010)
    //
    #endregion

    #region MacBookPro1,1 : class MacBookPro1_1
    //
    public class MacBookPro1_1 : MacBookPro
    {
        #region Class constructor
        //
        public MacBookPro1_1()
        {
            MacBookPro.AppleSMC.iKeys = new MacBookPro1_1_Keys();                       // Important! -> Initialize the AppleSMC keys for this MacBookPro model (without this initialisation the base class MacBookPro can not work)
            //
            MacBookPro.NOTEBOOK.MAINBOARD_TEMP_01.nhc_visible = false;                  // On this MacBookPro this temperature is not available. We can hide this class when we set nhc_visible to false.
            MacBookPro.NOTEBOOK.MAINBOARD_TEMP_02.nhc_visible = false;
            MacBookPro.NOTEBOOK.CASE_TEMP_02.nhc_visible = false;
        }
        //
        #endregion

        #region Definition of the AppleSMC keys for the MacBookPro1,1
        //
        internal class MacBookPro1_1_Keys : MacBookPro.AppleSMC.InterfaceKeys           // Override the empty interface keys of the MacBookPro base class with valid keys
        {
            public override string CPU_TEMP { get { return "TC0D"; } }                  // CPU die temperature
            public override string CPU_PROXIMITY_TEMP { get { return "TC0P"; } }        // CPU proximity temperature
            public override string GPU_TEMP { get { return "TG0P"; } }                  // GPU die temperature
            public override string GPU_PROXIMITY_TEMP { get { return "TG0H"; } }        // GPU proximity temperature
            public override string MAINBOARD_TEMP_01 { get { return ""; } }             // -> Not available on this MacBookPro
            public override string MAINBOARD_TEMP_02 { get { return ""; } }             // -> Not available on this MacBookPro
            public override string MEMORY_TEMP { get { return "Tm0P"; } }               // Memory temperature
            public override string PCIE_SLOT_TEMP { get { return "Ts0P"; } }            // PCI Express Slot temperature
            public override string HEATSINK_TEMP { get { return "Th0H"; } }             // Heatsink temperature
            public override string CASE_TEMP_01 { get { return "TB0T"; } }              // Enclosure bottom temperature 1
            public override string CASE_TEMP_02 { get { return ""; } }                  // -> Not available on this MacBookPro
        }
        //
        #endregion
    }
    //
    #endregion

    #region MacBookPro2,2 : class MacBookPro2_2
    //
    public class MacBookPro2_2 : MacBookPro
    {
        #region Class constructor
        //
        public MacBookPro2_2()
        {
            MacBookPro.AppleSMC.iKeys = new MacBookPro2_2_Keys();                       // Important! -> Initialize the AppleSMC keys for this MacBookPro model (without this initialisation the base class MacBookPro can not work)
            //
            MacBookPro.NOTEBOOK.MAINBOARD_TEMP_02.nhc_visible = false;                  // On this MacBookPro this temperature is not available. We can hide this class when we set nhc_visible to false.
            MacBookPro.NOTEBOOK.CASE_TEMP_02.nhc_visible = false;
        }
        //
        #endregion

        #region Definition of the AppleSMC keys for the MacBookPro2,2
        //
        internal class MacBookPro2_2_Keys : MacBookPro.AppleSMC.InterfaceKeys           // Override the empty interface keys of the MacBookPro base class with valid keys
        {
            public override string CPU_TEMP { get { return "TC0D"; } }                  // CPU die temperature
            public override string CPU_PROXIMITY_TEMP { get { return "TC0P"; } }        // CPU proximity temperature
            public override string GPU_TEMP { get { return "TG0T"; } }                  // GPU die temperature
            public override string GPU_PROXIMITY_TEMP { get { return "TG0P"; } }        // GPU proximity temperature
            public override string MAINBOARD_TEMP_01 { get { return "TTF0"; } }         // Mainboard temperature 1
            public override string MAINBOARD_TEMP_02 { get { return ""; } }             // -> Not available on this MacBookPro
            public override string MEMORY_TEMP { get { return "TM0P"; } }               // Memory temperature
            public override string PCIE_SLOT_TEMP { get { return "Ts0P"; } }            // PCI Express Slot temperature
            public override string HEATSINK_TEMP { get { return "Th0H"; } }             // Heatsink temperature
            public override string CASE_TEMP_01 { get { return "TB0T"; } }              // Enclosure bottom temperature 1
            public override string CASE_TEMP_02 { get { return ""; } }                  // -> Not available on this MacBookPro
        }
        //
        #endregion
    }
    //
    #endregion

    #region MacBookPro3,1 : class MacBookPro3_1
    //
    public class MacBookPro3_1 : MacBookPro
    {
        #region Class constructor
        //
        public MacBookPro3_1()
        {
            MacBookPro.AppleSMC.iKeys = new MacBookPro3_1_Keys();                       // Important! -> Initialize the AppleSMC keys for this MacBookPro model (without this initialisation the base class MacBookPro can not work)
            //
            MacBookPro.NOTEBOOK.CASE_TEMP_02.nhc_visible = false;                       // On this MacBookPro this temperature is not available. We can hide this class when we set nhc_visible to false.
        }
        //
        #endregion

        #region Definition of the AppleSMC keys for the MacBookPro3,1
        //
        internal class MacBookPro3_1_Keys : MacBookPro.AppleSMC.InterfaceKeys           // Override the empty interface keys of the MacBookPro base class with valid keys
        {
            public override string CPU_TEMP { get { return "TC0D"; } }                  // CPU die temperature
            public override string CPU_PROXIMITY_TEMP { get { return "TC0P"; } }        // CPU proximity temperature
            public override string GPU_TEMP { get { return "TG0D"; } }                  // GPU die temperature
            public override string GPU_PROXIMITY_TEMP { get { return "TG0H"; } }        // GPU proximity temperature
            public override string MAINBOARD_TEMP_01 { get { return "TTF0"; } }         // Mainboard temperature 1
            public override string MAINBOARD_TEMP_02 { get { return "TW0P"; } }         // Mainboard temperature 2
            public override string MEMORY_TEMP { get { return "Tm0P"; } }               // Memory temperature
            public override string PCIE_SLOT_TEMP { get { return "Ts0P"; } }            // PCI Express Slot temperature
            public override string HEATSINK_TEMP { get { return "Th2H"; } }             // Heatsink temperature
            public override string CASE_TEMP_01 { get { return "TB0T"; } }              // Enclosure bottom temperature 1
            public override string CASE_TEMP_02 { get { return ""; } }                  // -> Not available on this MacBookPro
        }
        //
        #endregion
    }
    //
    #endregion

    #region MacBookPro5,1 : class MacBookPro5_1
    //
    public class MacBookPro5_1 : MacBookPro
    {
        #region Class constructor
        //
        public MacBookPro5_1()
        {
            MacBookPro.AppleSMC.iKeys = new MacBookPro5_1_Keys();                       // Important! -> Initialize the AppleSMC keys for this MacBookPro model (without this initialisation the base class MacBookPro can not work)
        }
        //
        #endregion

        #region Definition of the AppleSMC keys for the MacBookPro5,1
        //
        internal class MacBookPro5_1_Keys : MacBookPro.AppleSMC.InterfaceKeys           // Override the empty interface keys of the MacBookPro base class with valid keys
        {
            public override string CPU_TEMP { get { return "TC0D"; } }                  // CPU die temperature
            public override string CPU_PROXIMITY_TEMP { get { return "TC0P"; } }        // CPU proximity temperature
            public override string GPU_TEMP { get { return "TG0D"; } }                  // GPU die temperature
            public override string GPU_PROXIMITY_TEMP { get { return "TG0P"; } }        // GPU proximity temperature
            public override string MAINBOARD_TEMP_01 { get { return "TN0D"; } }         // Mainboard temperature 1
            public override string MAINBOARD_TEMP_02 { get { return "TN0P"; } }         // Mainboard temperature 2
            public override string MEMORY_TEMP { get { return "Tm0P"; } }               // Memory temperature
            public override string PCIE_SLOT_TEMP { get { return "Ts0P"; } }            // PCI Express Slot temperature
            public override string HEATSINK_TEMP { get { return "Th2H"; } }             // Heatsink temperature
            public override string CASE_TEMP_01 { get { return "TB1T"; } }              // Enclosure bottom temperature 1
            public override string CASE_TEMP_02 { get { return "TB2T"; } }              // Enclosure bottom temperature 2
        }
        //
        #endregion
    }
    //
    #endregion

    #region MacBookPro5,4 : class MacBookPro5_4
    //
    public class MacBookPro5_4 : MacBookPro
    {
        #region Class constructor
        //
        public MacBookPro5_4()
        {
            MacBookPro.AppleSMC.iKeys = new MacBookPro5_4_Keys();                       // Important! -> Initialize the AppleSMC keys for this MacBookPro model (without this initialisation the base class MacBookPro can not work)
            //
            MacBookPro.NOTEBOOK.GPU_TEMPERATURE.nhc_visible = false;                    // On this MacBookPro this temperature is not available. We can hide this class when we set nhc_visible to false.
            MacBookPro.NOTEBOOK.GPU_PROXIMITY_TEMP.nhc_visible = false;
        }
        //
        #endregion

        #region Definition of the AppleSMC keys for the MacBookPro5,4
        //
        internal class MacBookPro5_4_Keys : MacBookPro.AppleSMC.InterfaceKeys           // Override the empty interface keys of the MacBookPro base class with valid keys
        {
            public override string CPU_TEMP { get { return "TC0D"; } }                  // CPU die temperature
            public override string CPU_PROXIMITY_TEMP { get { return "TC0P"; } }        // CPU proximity temperature
            public override string GPU_TEMP { get { return ""; } }                      // -> Not available on this MacBookPro
            public override string GPU_PROXIMITY_TEMP { get { return ""; } }            // -> Not available on this MacBookPro
            public override string MAINBOARD_TEMP_01 { get { return "TN0D"; } }         // Mainboard temperature 1
            public override string MAINBOARD_TEMP_02 { get { return "TN0P"; } }         // Mainboard temperature 2
            public override string MEMORY_TEMP { get { return "TTF0"; } }               // Memory temperature
            public override string PCIE_SLOT_TEMP { get { return "Ts0P"; } }            // PCI Express Slot temperature
            public override string HEATSINK_TEMP { get { return "Th2H"; } }             // Heatsink temperature
            public override string CASE_TEMP_01 { get { return "TB1T"; } }              // Enclosure bottom temperature 1
            public override string CASE_TEMP_02 { get { return "TB2T"; } }              // Enclosure bottom temperature 2
        }
        //
        #endregion
    }
    //
    #endregion

    #region MacBookPro6,2 : class MacBookPro6_2
    //
    public class MacBookPro6_2 : MacBookPro
    {
        #region Class constructor
        //
        public MacBookPro6_2()
        {
            MacBookPro.AppleSMC.iKeys = new MacBookPro6_2_Keys();                       // Important! -> Initialize the AppleSMC keys for this MacBookPro model (without this initialisation the base class MacBookPro can not work)
        }
        //
        #endregion

        #region Definition of the AppleSMC keys for the MacBookPro6,2
        //
        internal class MacBookPro6_2_Keys : MacBookPro.AppleSMC.InterfaceKeys           // Override the empty interface keys of the MacBookPro base class with valid keys
        {
            public override string CPU_TEMP { get { return "TC0D"; } }                  // CPU die temperature
            public override string CPU_PROXIMITY_TEMP { get { return "TC0P"; } }        // CPU proximity temperature
            public override string GPU_TEMP { get { return "TG0D"; } }                  // GPU die temperature
            public override string GPU_PROXIMITY_TEMP { get { return "TG0P"; } }        // GPU proximity temperature
            public override string MAINBOARD_TEMP_01 { get { return "TP0P"; } }         // Mainboard temperature 1
            public override string MAINBOARD_TEMP_02 { get { return "TPCD"; } }         // Mainboard temperature 2
            public override string MEMORY_TEMP { get { return "TMCD"; } }               // Memory temperature
            public override string PCIE_SLOT_TEMP { get { return "Ts0P"; } }            // PCI Express Slot temperature
            public override string HEATSINK_TEMP { get { return "Th1H"; } }             // Heatsink temperature
            public override string CASE_TEMP_01 { get { return "TB1T"; } }              // Enclosure bottom temperature 1
            public override string CASE_TEMP_02 { get { return "TB2T"; } }              // Enclosure bottom temperature 2
        }
        //
        #endregion
    }
    //
    #endregion

    #region MacBookPro7,1 : class MacBookPro7_1
    //
    public class MacBookPro7_1 : MacBookPro
    {
        #region Class constructor
        //
        public MacBookPro7_1()
        {
            MacBookPro.AppleSMC.iKeys = new MacBookPro7_1_Keys();                       // Important! -> Initialize the AppleSMC keys for this MacBookPro model (without this initialisation the base class MacBookPro can not work)
            //
            MacBookPro.NOTEBOOK.GPU_PROXIMITY_TEMP.nhc_visible = false;                 // On this MacBookPro this temperature is not available. We can hide this class when we set nhc_visible to false.
        }
        //
        #endregion

        #region Definition of the AppleSMC keys for the MacBookPro7,1
        //
        internal class MacBookPro7_1_Keys : MacBookPro.AppleSMC.InterfaceKeys           // Override the empty interface keys of the MacBookPro base class with valid keys
        {
            public override string CPU_TEMP { get { return "TC0D"; } }                  // CPU die temperature
            public override string CPU_PROXIMITY_TEMP { get { return "TC0P"; } }        // CPU proximity temperature
            public override string GPU_TEMP { get { return "TN1G"; } }                  // GPU temperature
            public override string GPU_PROXIMITY_TEMP { get { return ""; } }            // -> Not available on this MacBookPro
            public override string MAINBOARD_TEMP_01 { get { return "TN0D"; } }         // Mainboard temperature 1
            public override string MAINBOARD_TEMP_02 { get { return "TN0P"; } }         // Mainboard temperature 2
            public override string MEMORY_TEMP { get { return "TN1D"; } }               // Memory temperature
            public override string PCIE_SLOT_TEMP { get { return "Ts0P"; } }            // PCI Express Slot temperature
            public override string HEATSINK_TEMP { get { return "Th1H"; } }             // Heatsink temperature
            public override string CASE_TEMP_01 { get { return "TB1T"; } }              // Enclosure bottom temperature 1
            public override string CASE_TEMP_02 { get { return "TB2T"; } }              // Enclosure bottom temperature 2
        }
        //
        #endregion
    }
    //
    #endregion

    //  -   -   -

    #region MacBookPro base class : class MacBookPro
    //
    public class MacBookPro
    {
        public static string author = "Manfred Jaider";                             // The author of the class

        #region Ambient Light Sensor : class AMBIENT_LIGHT_SENSOR
        //
        public class AMBIENT_LIGHT_SENSOR
        {
            // Properties of this section class
            public const string description = "Ambient Light Sensor";               // Description of current class
            public const string tooltip = description;                              // Tooltip for the class (optimal)
            public const int icon = 144;                                            // Icon for the class (use the ACPI Class Editor to see all available icons)
            public const bool default_enabled = true;                               // If true the class is enabled in NHC by default (optional)

            #region Status text
            //
            // The optional status_text string allows us to display some status information (Note: NHC will detect and display changes of the status_text at runtime)
            // Note: NHC refreshes the status_text on runtime. This allows us to display also changing status in this field.
            //
            public static string status_text =  "+----------------------+-------------------+" + NEW_LINE +
                                                "| Light source         | Illuminance [Lux] |" + NEW_LINE +
                                                "+----------------------+-------------------+" + NEW_LINE +
                                                "| Candle (1m distance) |                1  |" + NEW_LINE +
                                                "| Street light         |               20  |" + NEW_LINE +
                                                "| Office desk lighting |              750  |" + NEW_LINE +
                                                "| Overcast day         |             3000  |" + NEW_LINE +
                                                "| Overcast sunny day   |            20000  |" + NEW_LINE +
                                                "| Direct sunlight      |           100000  |" + NEW_LINE +
                                                "+----------------------+-------------------+" + NEW_LINE;
            //

            //
            #endregion

            #region Value class for Average Ambient Light : class AVERANGE_AMBIENT_LIGHT
            //
            public class AVERANGE_AMBIENT_LIGHT
            {
                // Properties of this value class
                public const string description = "Average Ambient Light";          // Description for the value
                public const string tooltip = description;                          // Tooltip for the value
                public const int icon = 74;                                         // Icon for the value

                // Value
                public static ushort averange_ambient_light = 0;                    // It must have the same name as the class (case are ignored)
                public const string unit = "Lux";                                   // unit for the value
            }
            //
            #endregion

            #region nhcFunction: refresh()
            //
            // NHC will call this optional function with the time interval of refresh_interval
            //
            public const int refresh_interval = 1;                                  // refresh interval in seconds
            public const bool simple_refresh = true;                                // if true NHC will call the refresh function only if this class is visible on the user surface
            public static bool refresh()
            {
                #region Read Average Ambient Light from Apple SMC
                //
                ushort ambient_light = 0;
                int smc_result = 0;
                if (AppleSMC.read_UInt16(AppleSMC.dKeys.AVERANGE_AMBIENT_LIGHT, ref ambient_light, ref smc_result) == false)    // read light value
                {
                    return false;
                }
                if (smc_result == 0)
                {
                    AVERANGE_AMBIENT_LIGHT.averange_ambient_light = AppleSMC.endian_swap2byte(ambient_light);                   // convert Motorola UInt16 to Intel UInt16
                }
                //
                #endregion

                return true;
            }
            //
            #endregion
        }
        //
        public const string NEW_LINE = "\r\n";
        //
        #endregion

        #region Motion Sensor : class MOTION_SENSOR
        //
        public class MOTION_SENSOR
        {
            //  Properties of this section class
            public const string description = "Motion Sensor";                      // Description of current class
            public const string tooltip = description;                              // Tooltip for the class (optimal)
            public const int icon = 55;                                             // Icon for the class (use the ACPI Class Editor to see all available icons)
            public const bool default_enabled = true;                               // If true the class is enabled in NHC by default (optional)

            #region Value class for Motion Sensor X : class MOTION_SENSOR_X
            //
            public class MOTION_SENSOR_X
            {
                // Properties of this value class
                public const string description = "Motion Sensor X";                // Description for the value
                public const string tooltip = description;                          // Tooltip for the value
                public const int icon = 57;                                         // Icon for the value (use the ACPI Class Editor to see all available icons)

                // Value
                public static short motion_sensor_x = 0;                            // It must have the same name as the class (case are ignored)
                public const string unit = "°";                                     // unit of the value. The value can be masked with the unit string when we use the separator character '|'. Example: The unit string "OFF|ON" will be interpreted as "OFF" for the value 0 and "ON" for the value 1.
            }
            //
            #endregion

            #region Value class for Motion Sensor Y : class MOTION_SENSOR_Y
            //
            public class MOTION_SENSOR_Y
            {
                // Properties of this value class
                public const string description = "Motion Sensor Y";
                public const string tooltip = description;
                public const int icon = 58;

                // Value
                public static short motion_sensor_y = 0;
                public const string unit = "°";
            }
            //
            #endregion

            #region Value class for Motion Sensor Z : class MOTION_SENSOR_Z
            //
            public class MOTION_SENSOR_Z
            {
                // Properties of this value class
                public const string description = "Motion Sensor Z";
                public const string tooltip = description;
                public const int icon = 58;

                // Value
                public static short motion_sensor_z = 0;
                public const string unit = "°";
            }
            //
            #endregion

            //  -   -   -

            #region nhcFunction: init()
            //
            // optional init function -> NHC will call this function on initialisation (after the nhc_on_write() functions)
            public static bool init()
            {
                #region Initialize the Motion Sensor (Accelerometer)
                //
                int smc_result = 0;
                ushort smc_register = 0;
                if (AppleSMC.read_UInt16(AppleSMC.dKeys.MOTION_SENSOR_CONTROL_REGISTER, ref smc_register, ref smc_result) == false)     // read current accelerometer register value
                {
                    return false;
                }
                if ((smc_register & 0x00E0) != 0x00E0)                                                                                  // check if the necessary bits 0x00E0 are set
                {
                    smc_register = (ushort)(smc_register | 0x00E0);                                                                     // set the control register bits 0x00E0 (0000 0000 1110 0000)
                    if (AppleSMC.write_UInt16(AppleSMC.dKeys.MOTION_SENSOR_CONTROL_REGISTER, smc_register, ref smc_result) == false)    // initialize the accelerometer with the
                    {
                        return false;
                    }
                }
                //
                #endregion

                return true;
            }
            //
            #endregion

            #region nhcFunction: refresh()
            //
            // optional refresh function -> NHC will call this function in the time interval which is defined in refresh_interval
            public const int refresh_interval = 1;                                  // refresh interval in seconds
            public const bool simple_refresh = true;                                // if true NHC will call the refresh function only if this class is visible on the user surface
            public static bool refresh()
            {
                #region Read Motion Sensor X value
                //
                short sensor_value = 0;
                int smc_result = 0;
                if (AppleSMC.read_Int16(AppleSMC.dKeys.MOTION_SENSOR_X, ref sensor_value, ref smc_result) == false)             // read motion value
                {
                    return false;
                }
                if (smc_result == 0)
                {
                    MOTION_SENSOR_X.motion_sensor_x = AppleSMC.endian_swap2byte(sensor_value);                                  // convert Motorola UInt16 to Intel UInt16
                }
                //
                #endregion

                #region Read Motion Sensor Y value
                //
                if (AppleSMC.read_Int16(AppleSMC.dKeys.MOTION_SENSOR_Y, ref sensor_value, ref smc_result) == false)
                {
                    return false;
                }
                if (smc_result == 0)
                {
                    MOTION_SENSOR_Y.motion_sensor_y = AppleSMC.endian_swap2byte(sensor_value);
                }
                //
                #endregion

                #region Read Motion Sensor Z value
                //
                if (AppleSMC.read_Int16(AppleSMC.dKeys.MOTION_SENSOR_Z, ref sensor_value, ref smc_result) == false)
                {
                    return false;
                }
                if (smc_result == 0)
                {
                    MOTION_SENSOR_Z.motion_sensor_z = AppleSMC.endian_swap2byte(sensor_value);
                }
                //
                #endregion

                return true;
            }
            //
            #endregion
        }
        //
        #endregion

        #region Processor Info : class CPU
        //
        public class CPU
        {
            // Properties of this section class
            public const string description = "Processor Information";              // Description for the class
            public const string tooltip = description;                              // Tooltip for the class (optimal)
            public const int icon = 16;                                             // Icon for the class (use the ACPI Class Editor to see all available icons)
            public const bool default_enabled = true;                               // If true the class is enabled in NHC by default (optional)
            public const bool thermal_zone = true;                                  // NHC will add this class to the NHC Thermal Zone if this value is true (Thermal Zone Value class is also required)

            #region Value class for CPU current consumption : class CPU_CORE_CURRENT
            //
            public class CPU_CORE_CURRENT
            {
                // Properties of this value class
                public const string description = "CPU current consumption";        // Description for the value
                public const string tooltip = description;                          // Tooltip for the value
                public const int icon = 6;                                          // Icon for the value (use the ACPI Class Editor to see all available icons)

                // Value
                public static double cpu_core_current = 0;                          // It must have the same name as the class (case are ignored)
                public const string unit = "A";                                     // unit of the value. The value can be masked with the unit string when we use the separator character '|'. Example: The unit string "OFF|ON" will be interpreted as "OFF" for the value 0 and "ON" for the value 1.
            }
            //
            #endregion

            #region Value class for CPU power consumption : class CPU_CORE_POWER
            //
            public class CPU_CORE_POWER
            {
                // Properties of this value class
                public const string description = "CPU power consumption";
                public const string tooltip = description;

                public const int icon = 137;

                // Value
                public static double cpu_core_power = 0;
                public const string unit = "W";
            }
            //
            #endregion

            #region Value class for CPU temperature : class _TMP
            //
            public class _TMP                                                       // Note: When we set the name of the class to _TMP, the Thermal Zone will recognise this value as the CPU temperature
            {
                // Properties of this value class
                public const string description = "CPU temperature";
                public const string tooltip = description;
                public const int icon = 5;
                public const bool thermal_zone = true;                              // NHC will add this value class to the NHC Thermal Zone if this value is true

                // Value
                public static double _tmp = 0;
                public const string unit = "°C";
            }
            //
            #endregion

            #region Value class for CPU proximity temperature : class CPU_PROXIMITY_TEMP
            //
            public class CPU_PROXIMITY_TEMP
            {
                // Properties of this value class
                public const string description = "CPU proximity temperature";
                public const string tooltip = description;
                public const int icon = 5;
                public const bool thermal_zone = true;

                // Value
                public static double cpu_proximity_temp = 0;
                public const string unit = "°C";
            }
            //
            #endregion

            //  -   -   -

            #region nhcFunction: refresh()
            //
            // NHC will call this optional function with the time interval of refresh_interval
            //
            public const int refresh_interval = 1;                                  // refresh interval in seconds
            public const bool simple_refresh = true;                                // if true NHC will call the refresh function only if this class is visible on the user surface
            public static bool refresh()
            {

                #region Read CPU current consumption from Apple SMC
                //
                ushort current = 0;
                int smc_result = 0;
                if (AppleSMC.read_UInt16(AppleSMC.dKeys.CPU_CORE_CURRENT, ref current, ref smc_result) == false)    // read current value from AppleSMC
                {
                    return false;
                }
                if (smc_result == 0)
                {
                    current = AppleSMC.endian_swap2byte(current);                                                   // convert Motorola UInt16 to Intel UInt16
                    CPU_CORE_CURRENT.cpu_core_current = (double)current / 1000;                                     // convert mA to A
                }
                //
                #endregion

                #region Read CPU power consumption from Apple SMC
                //
                ushort power = 0;
                if (AppleSMC.read_UInt16(AppleSMC.dKeys.CPU_CORE_POWER, ref power, ref smc_result) == false)        // read power value from AppleSMC
                {
                    return false;
                }
                if (smc_result == 0)
                {
                    CPU_CORE_POWER.cpu_core_power = AppleSMC.encode_temperature(power);                                  // convert to AppleSMC double
                }
                //
                #endregion


                if (FAN_CONTROL.enabled == false)                                   // if the Fan Control is enabled, it is not necessary to refresh the temperatures - the fan control will do it already
                {
                    return refresh_temperatures();
                }
                else
                {
                    return true;
                }
            }
            //
            #endregion

            #region refresh_temperatures()
            //
            public static bool refresh_temperatures()
            {
                #region Read CPU temperature from Apple SMC
                //
                int smc_result = 0;
                ushort temperature = 0;
                if (AppleSMC.read_UInt16(AppleSMC.iKeys.CPU_TEMP, ref temperature, ref smc_result) == false)            // read temperature value from AppleSMC
                {
                    return false;
                }
                if (smc_result == 0)
                {
                    _TMP._tmp = AppleSMC.encode_temperature(temperature);                                                // convert to AppleSMC double
                }
                //
                #endregion

                #region Read CPU proximity temperature from Apple SMC
                //
                if (AppleSMC.read_UInt16(AppleSMC.iKeys.CPU_PROXIMITY_TEMP, ref temperature, ref smc_result) == false)
                {
                    return false;
                }
                if (smc_result == 0)
                {
                    CPU_PROXIMITY_TEMP.cpu_proximity_temp = AppleSMC.encode_temperature(temperature);
                }
                //
                #endregion

                return true;
            }
            //
            #endregion
        }
        //
        #endregion

        #region Notebook Info : class NOTEBOOK
        //
        public class NOTEBOOK
        {
            // Properties of this section class
            public const string description = "Notebook Information";               // Description for the class
            public const string tooltip = description;                              // Tooltip for the class (optimal)
            public const int icon = 11;                                             // Icon for the class (use the ACPI Class Editor to see all available icons)
            public const bool default_enabled = true;                               // If true the class is enabled in NHC by default (optional)
            public const bool thermal_zone = true;                                  // NHC will interpret this class also as a Thermal Zone zone class if this value is true

            #region Value class for power supply current consumption : class POWER_SUPPLY_CURRENT
            //
            public class POWER_SUPPLY_CURRENT
            {
                // Properties of this value class
                public const string description = "Power supply current consumption";       // Description for the value
                public const string tooltip = description;                          // Tooltip for the value
                public const int icon = 6;                                          // Icon for the value (use the ACPI Class Editor to see all available icons)
                public static bool nhc_visible = true;                              // If the optional filed "nhc_visible = false" the class is not visible in NHC. Useful if we want to hide this class.

                // Value
                public static double power_supply_current = 0;                      // It must have the same name as the class (case are ignored)
                public const string unit = "A";                                     // unit of the value. The value can be masked with the unit string when we use the separator character '|'. Example: The unit string "OFF|ON" will be interpreted as "OFF" for the value 0 and "ON" for the value 1.
            }
            //
            #endregion

            #region Value class for power supply power consumption : class POWER_SUPPLY_POWER
            //
            public class POWER_SUPPLY_POWER
            {
                // Properties of this value class
                public const string description = "Power supply power consumption";
                public const string tooltip = description;
                public const int icon = 137;
                public static bool nhc_visible = true;

                // Value
                public static double power_supply_power = 0;
                public const string unit = "W";
            }
            //
            #endregion

            #region Value class for GPU temperature : class GPU_TEMPERATURE
            //
            public class GPU_TEMPERATURE
            {
                // Properties of this value class
                public const string description = "GPU temperature";                // Description for the value
                public const string tooltip = description;                          // Tooltip for the value
                public const int icon = 19;                                         // Icon for the value (use the ACPI Class Editor to see all available icons)
                public const bool thermal_zone = true;                              // NHC will add this value class to the NHC Thermal Zone if this value is true
                public static bool nhc_visible = true;                              // If the optional filed "nhc_visible = false" the class is not visible in NHC. Useful if we want to hide this class.


                // Value
                public static double gpu_temperature = 0;                           // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of the value. The value can be masked with the unit string when we use the separator character '|'. Example: The unit string "OFF|ON" will be interpreted as "OFF" for the value 0 and "ON" for the value 1.
            }
            //
            #endregion

            #region Value class for GPU proximity temperature : class GPU_PROXIMITY_TEMP
            //
            public class GPU_PROXIMITY_TEMP
            {
                // Properties of this value class
                public const string description = "GPU proximity temperature";
                public const string tooltip = description;
                public const int icon = 19;
                public const bool thermal_zone = true;
                public static bool nhc_visible = true;

                // Value
                public static double gpu_proximity_temp = 0;
                public const string unit = "°C";
            }
            //
            #endregion

            #region Value class for mainboard temperature 1 : class MAINBOARD_TEMP_01
            //
            public class MAINBOARD_TEMP_01
            {
                // Properties of this value class
                public const string description = "Mainboard temperature 1";
                public const string tooltip = description;
                public const int icon = 26;
                public const bool thermal_zone = true;
                public static bool nhc_visible = true;

                // Value
                public static double mainboard_temp_01 = 0;
                public const string unit = "°C";
            }
            //
            #endregion

            #region Value class for mainboard temperature 2 : class MAINBOARD_TEMP_02
            //
            public class MAINBOARD_TEMP_02
            {
                // Properties of this value class
                public const string description = "Mainboard temperature 2";
                public const string tooltip = description;
                public const int icon = 26;
                public const bool thermal_zone = true;
                public static bool nhc_visible = true;

                // Value
                public static double mainboard_temp_02 = 0;
                public const string unit = "°C";
            }
            //
            #endregion

            #region Value class for memory temperature : class MEMORY_TEMP
            //
            public class MEMORY_TEMP
            {
                // Properties of this value class
                public const string description = "Memory temperature";
                public const string tooltip = description;
                public const int icon = 23;
                public const bool thermal_zone = true;
                public static bool nhc_visible = true;

                // Value
                public static double memory_temp = 0;
                public const string unit = "°C";
            }
            //
            #endregion

            #region Value class for PCI Express Slot temperature : class PCIE_TEMP
            //
            public class PCIE_SLOT_TEMP
            {
                // Properties of this value class
                public const string description = "PCI Express Slot temperature";
                public const string tooltip = description;
                public const int icon = 28;
                public const bool thermal_zone = true;
                public static bool nhc_visible = true;

                // Value
                public static double pcie_slot_temp = 0;
                public const string unit = "°C";
            }
            //
            #endregion

            #region Value class for Heatsink temperature : class PCIE_TEMP
            //
            public class HEATSINK_TEMP
            {
                // Properties of this value class
                public const string description = "Heatsink temperature";
                public const string tooltip = description;
                public const int icon = 36;
                public const bool thermal_zone = true;
                public static bool nhc_visible = true;

                // Value
                public static double heatsink_temp = 0;
                public const string unit = "°C";
            }
            //
            #endregion

            #region Value class for case temperature 1 : class CASE_TEMP_01
            //
            public class CASE_TEMP_01
            {
                // Properties of this value class
                public const string description = "Case temperature 1";
                public const string tooltip = description;
                public const int icon = 10;
                public const bool thermal_zone = true;
                public static bool nhc_visible = true;

                // Value
                public static double case_temp_01 = 0;
                public const string unit = "°C";
            }
            //
            #endregion

            #region Value class for case temperature 2 : class CASE_TEMP_02
            //
            public class CASE_TEMP_02
            {
                // Properties of this value class
                public const string description = "Case temperature 2";
                public const string tooltip = description;
                public const int icon = 10;
                public const bool thermal_zone = true;
                public static bool nhc_visible = true;


                // Value
                public static double case_temp_02 = 0;
                public const string unit = "°C";
            }
            //
            #endregion

            #region nhcFunction: refresh()
            //
            // NHC will call this optional function with the time interval of refresh_interval
            //
            public const int refresh_interval = 1;                                  // refresh interval in seconds
            public const bool simple_refresh = true;                                // if true NHC will call the refresh function only if this class is visible on the user surface
            public static bool refresh()
            {
                #region Read power supply current consumption from Apple SMC
                //
                int smc_result = 0;
                if (POWER_SUPPLY_CURRENT.nhc_visible == true)
                {
                    ushort current = 0;
                    if (AppleSMC.read_UInt16(AppleSMC.dKeys.POWER_SUPPLY_CURRENT, ref current, ref smc_result) == false)    // read current value from AppleSMC
                    {
                        return false;
                    }
                    if (smc_result == 0)
                    {
                        current = AppleSMC.endian_swap2byte(current);                                                       // convert Motorola UInt16 to Intel UInt16
                        POWER_SUPPLY_CURRENT.power_supply_current = (double)current / 1000;                                 // convert mA to A
                    }
                }
                //
                #endregion

                #region Read power supply power consumption from Apple SMC
                //
                if (POWER_SUPPLY_POWER.nhc_visible == true)
                {
                    ushort power = 0;
                    if (AppleSMC.read_UInt16(AppleSMC.dKeys.POWER_SUPPLY_POWER, ref power, ref smc_result) == false)        // read power value from AppleSMC
                    {
                        return false;
                    }
                    if (smc_result == 0)
                    {
                        POWER_SUPPLY_POWER.power_supply_power = AppleSMC.encode_temperature(power);                         // convert to AppleSMC double
                    }
                }
                //
                #endregion

                #region Read GPU temperature from Apple SMC
                //
                ushort temperature = 0;
                if (GPU_TEMPERATURE.nhc_visible == true)
                {
                    if (AppleSMC.read_UInt16(AppleSMC.iKeys.GPU_TEMP, ref temperature, ref smc_result) == false)            // read temperature value from AppleSMC
                    {
                        return false;
                    }
                    if (smc_result == 0)
                    {
                        GPU_TEMPERATURE.gpu_temperature = AppleSMC.encode_temperature(temperature);                         // convert to AppleSMC double
                    }
                }
                //
                #endregion

                #region Read GPU proximity temperature from Apple SMC
                //
                if (GPU_PROXIMITY_TEMP.nhc_visible == true)
                {
                    if (AppleSMC.read_UInt16(AppleSMC.iKeys.GPU_PROXIMITY_TEMP, ref temperature, ref smc_result) == false)
                    {
                        return false;
                    }
                    if (smc_result == 0)
                    {
                        GPU_PROXIMITY_TEMP.gpu_proximity_temp = AppleSMC.encode_temperature(temperature);
                    }
                }
                //
                #endregion

                #region Read mainboard temperature 1 from Apple SMC
                //
                if (MAINBOARD_TEMP_01.nhc_visible == true)
                {
                    if (AppleSMC.read_UInt16(AppleSMC.iKeys.MAINBOARD_TEMP_01, ref temperature, ref smc_result) == false)
                    {
                        return false;
                    }
                    if (smc_result == 0)
                    {
                        MAINBOARD_TEMP_01.mainboard_temp_01 = AppleSMC.encode_temperature(temperature);
                    }
                }
                //
                #endregion

                #region Read mainboard temperature 2 from Apple SMC
                //
                if (MAINBOARD_TEMP_02.nhc_visible == true)
                {
                    if (AppleSMC.read_UInt16(AppleSMC.iKeys.MAINBOARD_TEMP_02, ref temperature, ref smc_result) == false)
                    {
                        return false;
                    }
                    if (smc_result == 0)
                    {
                        MAINBOARD_TEMP_02.mainboard_temp_02 = AppleSMC.encode_temperature(temperature);
                    }
                }
                //
                #endregion

                #region Read memory temperature from Apple SMC
                //
                if (MEMORY_TEMP.nhc_visible == true)
                {

                    if (AppleSMC.read_UInt16(AppleSMC.iKeys.MEMORY_TEMP, ref temperature, ref smc_result) == false)
                    {
                        return false;
                    }
                    if (smc_result == 0)
                    {
                        MEMORY_TEMP.memory_temp = AppleSMC.encode_temperature(temperature);
                    }
                }
                //
                #endregion

                #region Read PCI Express Slot temperature from Apple SMC
                //
                if (PCIE_SLOT_TEMP.nhc_visible == true)
                {

                    if (AppleSMC.read_UInt16(AppleSMC.iKeys.PCIE_SLOT_TEMP, ref temperature, ref smc_result) == false)
                    {
                        return false;
                    }
                    if (smc_result == 0)
                    {
                        PCIE_SLOT_TEMP.pcie_slot_temp = AppleSMC.encode_temperature(temperature);
                    }
                }
                //
                #endregion

                #region Read heatsink temperature from Apple SMC
                //
                if (HEATSINK_TEMP.nhc_visible == true)
                {
                    if (AppleSMC.read_UInt16(AppleSMC.iKeys.HEATSINK_TEMP, ref temperature, ref smc_result) == false)
                    {
                        return false;
                    }
                    if (smc_result == 0)
                    {
                        HEATSINK_TEMP.heatsink_temp = AppleSMC.encode_temperature(temperature);
                    }
                }
                //
                #endregion

                #region Read case temperature 1 from Apple SMC
                //
                if (CASE_TEMP_01.nhc_visible == true)
                {

                    if (AppleSMC.read_UInt16(AppleSMC.iKeys.CASE_TEMP_01, ref temperature, ref smc_result) == false)
                    {
                        return false;
                    }
                    if (smc_result == 0)
                    {
                        CASE_TEMP_01.case_temp_01 = AppleSMC.encode_temperature(temperature);
                    }
                }
                //
                #endregion

                #region Read case temperature 2 from Apple SMC
                //
                if (CASE_TEMP_02.nhc_visible == true)
                {
                    if (AppleSMC.read_UInt16(AppleSMC.iKeys.CASE_TEMP_02, ref temperature, ref smc_result) == false)        // read temperature value from AppleSMC
                    {
                        return false;
                    }
                    if (smc_result == 0)
                    {
                        CASE_TEMP_02.case_temp_02 = AppleSMC.encode_temperature(temperature);                                    // convert to AppleSMC double
                    }
                }
                //
                #endregion

                return true;
            }
            //
            #endregion
        }
        //
        #endregion

        #region FAN Status : class FAN_STATUS
        //
        public class FAN_STATUS
        {
            // Properties of this section class
            public const string description = "Fan Status";                         // Description for the class
            public const string tooltip = "Fan Status";                             // Tooltip for the class (optimal)
            public const int icon = 2;                                              // Icon for the class (use the ACPI Class Editor to see all available icons)
            public const bool default_enabled = true;                               // If true the class is enabled in NHC by default (optional)
            public static bool nhc_visible = true;                                  // If false the class is not visible in NHC (optional). Modifications at runtime of nhc_visible outside the class constructor are ignored.

            // Custom definitions
            public static byte fan_count = 0;

            #region Class constructor
            //
            public FAN_STATUS()
            {
                #region get the fan count
                //
                fan_count = 0;
                if (AppleSMC.read_byte_safe(AppleSMC.dKeys.FANS_COUNT, ref fan_count) == false)
                {
                    nhc_visible = false;                // ERROR - hide this class
                    return;
                }
                else if (fan_count == 0)
                {
                    nhc_visible = false;                // NO FAN found - hide this class
                    return;
                }
                else if (fan_count > 4)
                {
                    fan_count = 4;                      // Limit the FAN count to 4 fans (normally there are not more as 4 fans in the notebook)
                }
                //
                #endregion

                #region init the available FAN classes (set fan description and get fan speed limits from Apple SMC)
                //
                FAN0_SPEED.nhc_visible = true;
                //
                //  get fan position and description
                FAN0_SPEED.fan_position = get_fan_position_text(AppleSMC.dKeys.FAN_POSITION_0);
                FAN0_SPEED.description = get_fan_speed_text(0, FAN0_SPEED.fan_position, "Actual");
                FAN0_SPEED.tooltip = FAN0_SPEED.description;
                //
                //  get fan speed info
                AppleSMC.read_UInt16_safe(AppleSMC.dKeys.FAN_MIN_SPEED_0, ref FAN0_SPEED.fan_min_speed);
                AppleSMC.read_UInt16_safe(AppleSMC.dKeys.FAN_MAX_SPEED_0, ref FAN0_SPEED.fan_max_speed);
                AppleSMC.read_UInt16_safe(AppleSMC.dKeys.FAN_SAFE_SPEED_0, ref FAN0_SPEED.fan_safe_speed);
                //
                //  encode fan speed
                FAN0_SPEED.fan_min_speed = AppleSMC.encode_speed(FAN0_SPEED.fan_min_speed);
                FAN0_SPEED.fan_max_speed = AppleSMC.encode_speed(FAN0_SPEED.fan_max_speed);
                FAN0_SPEED.fan_safe_speed = AppleSMC.encode_speed(FAN0_SPEED.fan_safe_speed);
                //
                if (fan_count >= 2)
                {
                    FAN1_SPEED.nhc_visible = true;
                    //
                    //  get fan position and description
                    FAN1_SPEED.fan_position = get_fan_position_text(AppleSMC.dKeys.FAN_POSITION_1);
                    FAN1_SPEED.description = get_fan_speed_text(1, FAN1_SPEED.fan_position, "Actual");
                    FAN1_SPEED.tooltip = FAN1_SPEED.description;
                    //
                    //  get fan speed info
                    AppleSMC.read_UInt16_safe(AppleSMC.dKeys.FAN_MIN_SPEED_1, ref FAN1_SPEED.fan_min_speed);
                    AppleSMC.read_UInt16_safe(AppleSMC.dKeys.FAN_MAX_SPEED_1, ref FAN1_SPEED.fan_max_speed);
                    AppleSMC.read_UInt16_safe(AppleSMC.dKeys.FAN_SAFE_SPEED_1, ref FAN1_SPEED.fan_safe_speed);
                    //
                    //  encode fan speed
                    FAN1_SPEED.fan_min_speed = AppleSMC.encode_speed(FAN1_SPEED.fan_min_speed);
                    FAN1_SPEED.fan_max_speed = AppleSMC.encode_speed(FAN1_SPEED.fan_max_speed);
                    FAN1_SPEED.fan_safe_speed = AppleSMC.encode_speed(FAN1_SPEED.fan_safe_speed);
                }
                if (fan_count >= 3)
                {
                    FAN2_SPEED.nhc_visible = true;
                    //
                    //  get fan position and description
                    FAN2_SPEED.fan_position = get_fan_position_text(AppleSMC.dKeys.FAN_POSITION_2);
                    FAN2_SPEED.description = get_fan_speed_text(2, FAN2_SPEED.fan_position, "Actual");
                    FAN2_SPEED.tooltip = FAN2_SPEED.description;
                    //
                    //  get fan speed info
                    AppleSMC.read_UInt16_safe(AppleSMC.dKeys.FAN_MIN_SPEED_2, ref FAN2_SPEED.fan_min_speed);
                    AppleSMC.read_UInt16_safe(AppleSMC.dKeys.FAN_MAX_SPEED_2, ref FAN2_SPEED.fan_max_speed);
                    AppleSMC.read_UInt16_safe(AppleSMC.dKeys.FAN_SAFE_SPEED_2, ref FAN2_SPEED.fan_safe_speed);
                    //
                    //  encode fan speed
                    FAN2_SPEED.fan_min_speed = AppleSMC.encode_speed(FAN2_SPEED.fan_min_speed);
                    FAN2_SPEED.fan_max_speed = AppleSMC.encode_speed(FAN2_SPEED.fan_max_speed);
                    FAN2_SPEED.fan_safe_speed = AppleSMC.encode_speed(FAN2_SPEED.fan_safe_speed);
                }
                if (fan_count >= 4)
                {
                    FAN3_SPEED.nhc_visible = true;
                    //
                    //  get fan position and description
                    FAN3_SPEED.fan_position = get_fan_position_text(AppleSMC.dKeys.FAN_POSITION_3);
                    FAN3_SPEED.description = get_fan_speed_text(3, FAN3_SPEED.fan_position, "Actual");
                    FAN3_SPEED.tooltip = FAN3_SPEED.description;
                    //
                    //  get fan speed info
                    AppleSMC.read_UInt16_safe(AppleSMC.dKeys.FAN_MIN_SPEED_3, ref FAN3_SPEED.fan_min_speed);
                    AppleSMC.read_UInt16_safe(AppleSMC.dKeys.FAN_MAX_SPEED_3, ref FAN3_SPEED.fan_max_speed);
                    AppleSMC.read_UInt16_safe(AppleSMC.dKeys.FAN_SAFE_SPEED_3, ref FAN3_SPEED.fan_safe_speed);
                    //
                    //  encode fan speed
                    FAN3_SPEED.fan_min_speed = AppleSMC.encode_speed(FAN3_SPEED.fan_min_speed);
                    FAN3_SPEED.fan_max_speed = AppleSMC.encode_speed(FAN3_SPEED.fan_max_speed);
                    FAN3_SPEED.fan_safe_speed = AppleSMC.encode_speed(FAN3_SPEED.fan_safe_speed);
                }
                //
                #endregion
            }
            //
            #endregion

            #region Value class for Fan 0 Actual Speed : class FAN0_SPEED
            //
            public class FAN0_SPEED
            {
                // Properties of this value class
                public static string description = null;                            // We will set the description in the section class constructor
                public static string tooltip = null;
                public const int icon = 320;
                public static bool nhc_visible = false;                             // If false the class is not visible in NHC (optional). Modifications at runtime of nhc_visible outside the class constructor are ignored.

                // Value
                public static int fan0_speed = 0;
                public const string unit = "RPM";

                // Public variables
                public static string fan_position = null;
                public static ushort fan_min_speed = 0;
                public static ushort fan_max_speed = 0;
                public static ushort fan_safe_speed = 0;
            }
            //
            #endregion

            #region Value class for Fan 1 Actual Speed : class FAN1_SPEED
            //
            public class FAN1_SPEED
            {
                // Properties of this value class
                public static string description = null;                            // We will set the description in the section class constructor
                public static string tooltip = null;
                public const int icon = 320;
                public static bool nhc_visible = false;

                // Value
                public static int fan1_speed = 0;
                public const string unit = "RPM";

                // Public variables
                public static string fan_position = null;
                public static ushort fan_min_speed = 0;
                public static ushort fan_max_speed = 0;
                public static ushort fan_safe_speed = 0;
            }
            //
            #endregion

            #region Value class for Fan 2 Actual Speed : class FAN2_SPEED
            //
            public class FAN2_SPEED
            {
                // Properties of this value class
                public static string description = null;                            // We will set the description in the section class constructor
                public static string tooltip = null;
                public const int icon = 320;
                public static bool nhc_visible = false;

                // Value
                public static int fan2_speed = 0;
                public const string unit = "RPM";

                // Public variables
                public static string fan_position = null;
                public static ushort fan_min_speed = 0;
                public static ushort fan_max_speed = 0;
                public static ushort fan_safe_speed = 0;
            }
            //
            #endregion

            #region Value class for Fan 3 Actual Speed : class FAN3_SPEED
            //
            public class FAN3_SPEED
            {
                // Properties of this value class
                public static string description = null;                            // We will set the description in the section class constructor
                public static string tooltip = null;
                public const int icon = 320;
                public static bool nhc_visible = false;

                // Value
                public static int fan3_speed = 0;
                public const string unit = "RPM";

                // Public variables
                public static string fan_position = null;
                public static ushort fan_min_speed = 0;
                public static ushort fan_max_speed = 0;
                public static ushort fan_safe_speed = 0;
            }
            //
            #endregion

            //  -   -   -

            #region nhcFunction: refresh()
            //
            // NHC will call this optional function with the time interval of refresh_interval
            //
            public const int refresh_interval = 1;                                  // refresh interval in seconds
            public const bool simple_refresh = true;                                // if true NHC will call the refresh function only if this class is visible on the user surface
            public static bool refresh()
            {
                ushort uvalue = 0;
                int smc_result = 0;

                #region Read Fan 0 Actual Speed from Apple SMC
                //
                if (FAN0_SPEED.nhc_visible == true)
                {
                    if (AppleSMC.read_UInt16(AppleSMC.dKeys.FAN_ACTUAL_SPEED_0, ref uvalue, ref smc_result) == false)       // read the fan speed from the apple smc (Note: the key index starts from zero)
                    {
                        return false;
                    }
                    if (smc_result == 0)
                    {
                        FAN0_SPEED.fan0_speed = AppleSMC.encode_speed(uvalue);                                              // convert the apple smc data to the fan speed
                    }
                }
                //
                #endregion

                #region Read Fan 1 Actual Speed from Apple SMC
                //
                if (FAN1_SPEED.nhc_visible == true)
                {
                    if (AppleSMC.read_UInt16(AppleSMC.dKeys.FAN_ACTUAL_SPEED_1, ref uvalue, ref smc_result) == false)
                    {
                        return false;
                    }
                    if (smc_result == 0)
                    {
                        FAN1_SPEED.fan1_speed = AppleSMC.encode_speed(uvalue);
                    }
                }
                //
                #endregion

                #region Read Fan 2 Actual Speed from Apple SMC
                //
                if (FAN2_SPEED.nhc_visible == true)
                {
                    if (AppleSMC.read_UInt16(AppleSMC.dKeys.FAN_ACTUAL_SPEED_2, ref uvalue, ref smc_result) == false)
                    {
                        return false;
                    }
                    if (smc_result == 0)
                    {
                        FAN2_SPEED.fan2_speed = AppleSMC.encode_speed(uvalue);
                    }
                }
                //
                #endregion

                #region Read Fan 3 Actual Speed from Apple SMC
                //
                if (FAN3_SPEED.nhc_visible == true)
                {
                    if (AppleSMC.read_UInt16(AppleSMC.dKeys.FAN_ACTUAL_SPEED_3, ref uvalue, ref smc_result) == false)
                    {
                        return false;
                    }
                    if (smc_result == 0)
                    {
                        FAN3_SPEED.fan3_speed = AppleSMC.encode_speed(uvalue);
                    }
                }
                //
                #endregion

                return true;
            }
            //
            #endregion

            //  -   -   -

            #region get_fan_position_text()
            //
            // get fan position decription from apple smc - extract to left, right, top or bottom
            //
            private static string get_fan_position_text(string position_key)
            {
                string fan_position = null;
                if (AppleSMC.read_string_safe(position_key, ref fan_position) == false)
                {
                    return null;
                }
                //
                fan_position = fan_position.ToLowerInvariant();
                //
                if (fan_position.Contains("left") == true)
                {
                    return "Left";
                }
                else if (fan_position.Contains("right") == true)
                {
                    return "Right";
                }
                else if (fan_position.Contains("top") == true)
                {
                    return "Top";
                }
                else if (fan_position.Contains("bottom") == true)
                {
                    return "Bottom";
                }
                else
                {
                    return null;
                }
            }
            //
            #endregion

            #region get_fan_speed_text()
            //
            public static string get_fan_speed_text(int fan_number, string position, string type)
            {
                if (position == null)
                {
                    return "Fan " + fan_number + " " + type + " Speed";
                }
                else
                {
                    return "Fan " + position + " " + type + " Speed";
                }
            }
            //
            #endregion
        }
        //
        #endregion

        #region FAN Control : class FAN_CONTROL
        //
        public class FAN_CONTROL
        {
            // Properties of this section class
            public const string description = "Fan Control";                        // Description for the class
            public const string tooltip = "Fan Control";                            // Tooltip for the class (optimal)
            public const int icon = 193;                                            // Icon for the class (use the ACPI Class Editor to see all available icons)
            public const bool default_enabled = false;                              // If true the class is enabled in NHC by default (optional)
            public static bool nhc_visible = true;                                  // If false the class is not visible in NHC (optional). Modifications at runtime of nhc_visible outside the class constructor are ignored.
            public static string status_text = null;                                // The status_text string allows us to display some status information (optinal). NHC will also detect and display changes of the status_text at runtime.

            // Warning on enable (optimal)
            public const bool show_warning = true;                                  // If true NHC will show the warning_message if the user enables this section class (optimal)
            public const string warning_message =                                   // NHC will show this warning message if show_warning is true (optimal)
                "Please enable the Fan Control only if you know what you are doing! " +
                "The System can overhead if the Fan Control configuration is wrong." + NEW_LINE + NEW_LINE +
                "Do you really want to enable the Fan Control?";

            // Condition variables
            public static bool initialisation = false;                              // On initialisation NHC will set this variable to true; after the initialisation NHC will set this variable to false (optional)
            public static bool enabled = false;                                     // If NHC or the user enable this section class the variable enabled is true, it not enabled is false (optional)

            // Custom definitions
            private static byte fan_count = 0;
            private static ushort smc_fan_bits = 0;
            private static bool fan_control_enabled = false;
            private static double[] temperature_array = new double[5];
            private static int temperature_array_pos = 0;
            private static double average_temperature = 0;
            private static double last_average_temperature = 0;
            private static int last_calculated_fan_speed = 0;
            private const int fan_step_resolution = 10;                             // we support 10 different FAN speeds between min and max FAN speed

            #region Class constructor
            //
            public FAN_CONTROL()
            {
                #region Hide also the Fan Control class if the Fan Status class is not available
                //
                if (FAN_STATUS.nhc_visible == false)
                {
                    FAN_CONTROL.nhc_visible = false;
                    return;
                }
                //
                #endregion

                #region create status text -  get min and max value
                //
                status_text +=  "Fan Speed information from Apple SMC" + NEW_LINE;
                status_text +=  "------------------------------------" + NEW_LINE;
                //
                fan_count = FAN_STATUS.fan_count;       // get the fan count from FAN_STATUS
                //
                status_text +=  FAN_STATUS.get_fan_speed_text(0, FAN_STATUS.FAN0_SPEED.fan_position, "Min") + ": " + FAN_STATUS.FAN0_SPEED.fan_min_speed + " RPM" + NEW_LINE;
                status_text +=  FAN_STATUS.get_fan_speed_text(0, FAN_STATUS.FAN0_SPEED.fan_position, "Max") + ": " + FAN_STATUS.FAN0_SPEED.fan_max_speed + " RPM" + NEW_LINE;
                //
                if (FAN_STATUS.FAN0_SPEED.fan_safe_speed > FAN_STATUS.FAN0_SPEED.fan_min_speed)             // add fan safe speed only if it is valid
                {
                    status_text +=  FAN_STATUS.get_fan_speed_text(0, FAN_STATUS.FAN0_SPEED.fan_position, "Safe") + ": " + FAN_STATUS.FAN0_SPEED.fan_safe_speed + " RPM" + NEW_LINE;
                }
                //
                ushort smc_min = FAN_STATUS.FAN0_SPEED.fan_min_speed;
                ushort smc_max = FAN_STATUS.FAN0_SPEED.fan_max_speed;
                //
                if (fan_count >= 2)
                {
                    status_text +=  FAN_STATUS.get_fan_speed_text(1, FAN_STATUS.FAN1_SPEED.fan_position, "Min") + ": " + FAN_STATUS.FAN1_SPEED.fan_min_speed + " RPM" + NEW_LINE;
                    status_text +=  FAN_STATUS.get_fan_speed_text(1, FAN_STATUS.FAN1_SPEED.fan_position, "Max") + ": " + FAN_STATUS.FAN1_SPEED.fan_max_speed + " RPM" + NEW_LINE;
                    //
                    if (FAN_STATUS.FAN1_SPEED.fan_safe_speed > FAN_STATUS.FAN1_SPEED.fan_min_speed)         // add fan safe speed only if it is valid
                    {
                        status_text +=  FAN_STATUS.get_fan_speed_text(1, FAN_STATUS.FAN1_SPEED.fan_position, "Safe") + ": " + FAN_STATUS.FAN1_SPEED.fan_safe_speed + " RPM" + NEW_LINE;
                    }
                    //
                    if (FAN_STATUS.FAN1_SPEED.fan_min_speed < smc_min)
                    {
                        smc_min = FAN_STATUS.FAN1_SPEED.fan_min_speed;
                    }
                    if (FAN_STATUS.FAN1_SPEED.fan_max_speed > smc_max)
                    {
                        smc_max = FAN_STATUS.FAN1_SPEED.fan_max_speed;
                    }
                }
                if (fan_count >= 3)
                {
                    status_text +=  FAN_STATUS.get_fan_speed_text(2, FAN_STATUS.FAN2_SPEED.fan_position, "Min") + ": " + FAN_STATUS.FAN2_SPEED.fan_min_speed + " RPM" + NEW_LINE;
                    status_text +=  FAN_STATUS.get_fan_speed_text(2, FAN_STATUS.FAN2_SPEED.fan_position, "Max") + ": " + FAN_STATUS.FAN2_SPEED.fan_max_speed + " RPM" + NEW_LINE;
                    //
                    if (FAN_STATUS.FAN2_SPEED.fan_safe_speed > FAN_STATUS.FAN2_SPEED.fan_min_speed)         // add fan safe speed only if it is valid
                    {
                        status_text +=  FAN_STATUS.get_fan_speed_text(2, FAN_STATUS.FAN2_SPEED.fan_position, "Safe") + ": " + FAN_STATUS.FAN2_SPEED.fan_safe_speed + " RPM" + NEW_LINE;
                    }
                    //
                    if (FAN_STATUS.FAN2_SPEED.fan_min_speed < smc_min)
                    {
                        smc_min = FAN_STATUS.FAN2_SPEED.fan_min_speed;
                    }
                    if (FAN_STATUS.FAN2_SPEED.fan_max_speed > smc_max)
                    {
                        smc_max = FAN_STATUS.FAN2_SPEED.fan_max_speed;
                    }
                }
                if (fan_count >= 4)
                {
                    status_text +=  FAN_STATUS.get_fan_speed_text(3, FAN_STATUS.FAN3_SPEED.fan_position, "Min") + ": " + FAN_STATUS.FAN3_SPEED.fan_min_speed + " RPM" + NEW_LINE;
                    status_text +=  FAN_STATUS.get_fan_speed_text(3, FAN_STATUS.FAN3_SPEED.fan_position, "Max") + ": " + FAN_STATUS.FAN3_SPEED.fan_max_speed + " RPM" + NEW_LINE;
                    //
                    if (FAN_STATUS.FAN3_SPEED.fan_safe_speed > FAN_STATUS.FAN3_SPEED.fan_min_speed)         // add fan safe speed only if it is valid
                    {
                        status_text +=  FAN_STATUS.get_fan_speed_text(3, FAN_STATUS.FAN3_SPEED.fan_position, "Safe") + ": " + FAN_STATUS.FAN3_SPEED.fan_safe_speed + " RPM" + NEW_LINE;
                    }
                    //
                    if (FAN_STATUS.FAN3_SPEED.fan_min_speed < smc_min)
                    {
                        smc_min = FAN_STATUS.FAN3_SPEED.fan_min_speed;
                    }
                    if (FAN_STATUS.FAN3_SPEED.fan_max_speed > smc_max)
                    {
                        smc_max = FAN_STATUS.FAN3_SPEED.fan_max_speed;
                    }
                }
                //
                #endregion

                #region set default values
                //
                if ((smc_min < smc_max) && (smc_min != 0))
                {
                    FAN_MIN_SPEED.fan_min_speed = smc_min;
                    FAN_MIN_SPEED.NHC_WRITE.nhc_minimum_value = smc_min / 2;
                    FAN_MIN_SPEED.NHC_WRITE.nhc_default_value = smc_min;
                    FAN_MIN_SPEED.NHC_WRITE.nhc_maximum_value = smc_max;
                    //
                    FAN_MAX_SPEED.fan_max_speed = smc_max;
                    FAN_MAX_SPEED.NHC_WRITE.nhc_minimum_value = smc_min;
                    FAN_MAX_SPEED.NHC_WRITE.nhc_default_value = smc_max;
                    FAN_MAX_SPEED.NHC_WRITE.nhc_maximum_value = 0x3FFF;     // maximum 16Bit value
                }
                //
                #endregion

                #region get smc_fan_bits
                //
                fan_count = FAN_STATUS.fan_count;
                for (int i = 0; i < fan_count; i++)
                {
                    smc_fan_bits = (ushort)(smc_fan_bits | (1 << i));
                }
                smc_fan_bits = AppleSMC.endian_swap2byte(smc_fan_bits);
                //
                #endregion
            }
            //
            #endregion

            #region Value class FAN_MIN_SPEED : class FAN_MIN_SPEED
            //
            public class FAN_MIN_SPEED
            {
                // Properties of this value class
                public const string description = "Minimum FAN Speed";              // Description for the value
                public const string tooltip = description;                          // Tooltip for the value (optimal)
                public const int icon = 175;                                        // Icon for the value (use the ACPI Class Editor to see all available icons)
                public static bool nhc_visible = true;                              // If false the class is not visible in NHC (optional). Modifications at runtime of nhc_visible outside the class constructor are ignored.


                // Value
                public static int fan_min_speed = 8000;                             // It must have the same name as the class (case are ignored)
                public const string unit = "RPM";                                   // unit of the value. The value can be masked with the unit string when we use the separator character '|'. Example: The unit string "OFF|ON" will be interpreted as "OFF" for the value 0 and "ON" for the value 1.

                #region NHC_WRITE
                //
                //  With this optional class it is possible to change the value in NHC at runtime
                //
                public class NHC_WRITE
                {
                    // we will update this value in the section class constructor
                    public static int nhc_minimum_value = 4000;                     // minimum input value
                    public static int nhc_maximum_value = 16000;                    // maximum input value
                    public static int nhc_default_value = 8000;                     // default value
                    public static bool nhc_on_write()                               // optional function - NHC will call this function if the user change the value on runtime and on NHC start
                    {
                        if (initialisation == false)                                // only if the user has changed the value
                        {
                            invalidate_last_values();                               // force an immediate recalculation and update of the fan speed
                        }
                        return true;
                    }
                }
                //
                #endregion
            }
            //
            #endregion

            #region Value class MIN_SPEED_TEMPERATURE : class MIN_SPEED_TEMPERATURE
            //
            public class MIN_SPEED_TEMPERATURE
            {
                // Properties of this value class
                public const string description = "Minimum FAN Speed Temperature";  // Description for the value
                public const string tooltip = description;                          // Tooltip for the value (optimal)
                public const int icon = 182;                                        // Icon for the value (use the ACPI Class Editor to see all available icons)
                public static bool nhc_visible = true;                              // If false the class is not visible in NHC (optional). Modifications at runtime of nhc_visible outside the class constructor are ignored.

                // Value
                public static int min_speed_temperature = 30;                       // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of the value. The value can be masked with the unit string when we use the separator character '|'. Example: The unit string "OFF|ON" will be interpreted as "OFF" for the value 0 and "ON" for the value 1.

                #region NHC_WRITE
                //
                //  With this optional class it is possible to change the value in NHC at runtime
                //
                public class NHC_WRITE
                {
                    public static bool nhc_visible = true;                          // If false the class is not visible in NHC (optional). Modifications at runtime of nhc_visible outside the class constructor are ignored.
                    public const int nhc_minimum_value = 10;                        // minimum input value
                    public const int nhc_maximum_value = 60;                        // maximum input value
                    public const int nhc_default_value = 30;                        // default value
                    public static bool nhc_on_write()                               // optional function - NHC will call this function if the user change the value on runtime and on NHC start
                    {
                        if (initialisation == false)                                // only if the user has changed the value
                        {
                            invalidate_last_values();                               // force an immediate recalculation and update of the fan speed
                        }
                        return true;
                    }
                }
                //
                #endregion
            }
            //
            #endregion

            #region Value class FAN_MAX_SPEED : class FAN_MAX_SPEED
            //
            public class FAN_MAX_SPEED
            {
                // Properties of this value class
                public const string description = "Maximum FAN Speed";              // Description for the value
                public const string tooltip = description;                          // Tooltip for the value (optimal)
                public const int icon = 171;                                        // Icon for the value (use the ACPI Class Editor to see all available icons)
                public static bool nhc_visible = true;                              // If false the class is not visible in NHC (optional). Modifications at runtime of nhc_visible outside the class constructor are ignored.

                // Value
                public static int fan_max_speed = 16000;                            // It must have the same name as the class (case are ignored)
                public const string unit = "RPM";                                   // unit of the value. The value can be masked with the unit string when we use the separator character '|'. Example: The unit string "OFF|ON" will be interpreted as "OFF" for the value 0 and "ON" for the value 1.

                #region NHC_WRITE
                //
                //  With this optional class it is possible to change the value in NHC at runtime
                //
                public class NHC_WRITE
                {
                    // we will update this value in the section class constructor
                    public static int nhc_minimum_value = 8000;                     // minimum input value
                    public static int nhc_maximum_value = 16000;                    // maximum input value
                    public static int nhc_default_value = 16000;                    // default value
                    public static bool nhc_on_write()                               // optional function - NHC will call this function if the user change the value on runtime and on NHC start
                    {
                        if (initialisation == false)                                // only if the user has changed the value
                        {
                            invalidate_last_values();                               // force an immediate recalculation and update of the fan speed
                        }
                        return true;
                    }
                }
                //
                #endregion
            }
            //
            #endregion

            #region Value class MAX_SPEED_TEMPERATURE : class MAX_SPEED_TEMPERATURE
            //
            public class MAX_SPEED_TEMPERATURE
            {
                // Properties of this value class
                public const string description = "Maximum FAN Speed Temperature";  // Description for the value
                public const string tooltip = description;                          // Tooltip for the value (optimal)
                public const int icon = 179;                                        // Icon for the value (use the ACPI Class Editor to see all available icons)
                public static bool nhc_visible = true;                              // If false the class is not visible in NHC (optional). Modifications at runtime of nhc_visible outside the class constructor are ignored.

                // Value
                public static int max_speed_temperature = 80;                       // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of the value. The value can be masked with the unit string when we use the separator character '|'. Example: The unit string "OFF|ON" will be interpreted as "OFF" for the value 0 and "ON" for the value 1.

                #region NHC_WRITE
                //
                //  With this optional class it is possible to change the value in NHC at runtime
                //
                public class NHC_WRITE
                {
                    public static bool nhc_visible = true;                          // If false the class is not visible in NHC (optional). Modifications at runtime of nhc_visible outside the class constructor are ignored.
                    public const int nhc_minimum_value = 65;                        // minimum input value
                    public const int nhc_maximum_value = 90;                        // maximum input value
                    public const int nhc_default_value = 80;                        // default value
                    public static bool nhc_on_write()                               // optional function - NHC will call this function if the user change the value on runtime and on NHC start
                    {
                        if (initialisation == false)                                // only if the user has changed the value
                        {
                            invalidate_last_values();                               // force an immediate recalculation and update of the fan speed
                        }
                        return true;
                    }
                }
                //
                #endregion
            }
            //
            #endregion

            //  -   -   -

            #region nhcFunction: init()
            //
            //  NHC will call this optional function on initialisation or if the user enable the class
            //  Note: nhc_write() functions get initialized first
            //
            public static bool init()
            {
                fan_control_enabled = enable_custom_fan_control();
                if (fan_control_enabled == true)
                {
                    //  init the average_temperature and temperature_array
                    //
                    average_temperature = get_highest_temperature();
                    for (int i = 0; i < temperature_array.Length; i++)
                    {
                        temperature_array[i] = average_temperature;
                    }
                    //
                    //  invalidate the last values (force a refresh)
                    //
                    invalidate_last_values();
                    //
                    //  set the fan speed
                    //
                    calculate_and_set_fan_speed();
                }
                return fan_control_enabled;
            }
            //
            #region invalidate_last_values()
            //
            private static void invalidate_last_values()
            {
                last_average_temperature = double.MinValue;
                last_calculated_fan_speed = int.MinValue;
            }
            //
            #endregion
            //
            #endregion

            #region nhcFunction: close()
            //
            //  NHC will call this optional function on NHC exit or if the user disable the class
            //
            public static bool close()
            {
                while(fan_control_enabled == true)          // WE MUST disable the custom/manual FAN Control on exit (we give back the control to the AppleSMC if enabled)
                {
                    fan_control_enabled = !(disable_custom_fan_control());
                }
                return true;
            }
            //
            #endregion

            #region nhcFunction: refresh()
            //
            // NHC will call this optional function with the time interval of refresh_interval
            //
            public const int refresh_interval = 1;                                  // refresh interval in seconds
            public const bool simple_refresh = false;                               // We MUST have a normal refresh for the Fan Control (if true NHC will call the refresh function only if this class is visible on the user surface)
            public static bool refresh()
            {
                //  1. get/refresh average temperature
                //
                refresh_average_temperature();
                //
                //  2. set new fan speed if necessary
                //
                calculate_and_set_fan_speed();
                //
                return true;
            }
            //
            #endregion

            //  -   -   -

            #region refresh_average_temperature()
            //
            private static void refresh_average_temperature()
            {
                #region set new temperature in the temperature_array
                //
                temperature_array[temperature_array_pos] = get_highest_temperature();
                temperature_array_pos++;
                if (temperature_array_pos >= temperature_array.Length)
                {
                    temperature_array_pos = 0;
                }
                //
                #endregion

                #region get the average_temperature from the temperature_array
                //
                double sum = 0;
                for (int i = 0; i < temperature_array.Length; i++)
                {
                    sum = sum + temperature_array[i];
                }
                average_temperature = (double)(sum / temperature_array.Length);
                //
                #endregion
            }
            //
            #endregion

            #region get_highest_temperature()
            //
            private static double get_highest_temperature()
            {
                CPU.refresh_temperatures();
                //
                double temperature = CPU._TMP._tmp;
                if (CPU.CPU_PROXIMITY_TEMP.cpu_proximity_temp > temperature)
                {
                    temperature = CPU.CPU_PROXIMITY_TEMP.cpu_proximity_temp;
                }
                //
                return temperature;
            }
            //
            #endregion

            //  -   -   -

            #region calculate_and_set_fan_speed()
            //
            private static void calculate_and_set_fan_speed()
            {
                int new_calculated_fan_speed = calculate_fan_speed();           // calculate the new fan speed
                //
                if (last_calculated_fan_speed != new_calculated_fan_speed)      // update the new fan speed in the Apple SMC only if necessary
                {
                    last_calculated_fan_speed = new_calculated_fan_speed;
                    set_fan_speed_smc((ushort)new_calculated_fan_speed);
                }
            }
            //
            #endregion

            #region calculate_fan_speed()
            //
            private static int calculate_fan_speed()
            {
                if (last_average_temperature == average_temperature)
                {
                    return last_calculated_fan_speed;
                }
                else
                {
                    last_average_temperature = average_temperature;
                    //
                    if (average_temperature <= MIN_SPEED_TEMPERATURE.min_speed_temperature)
                    {
                        return FAN_MIN_SPEED.fan_min_speed;
                    }
                    else if (average_temperature >= MAX_SPEED_TEMPERATURE.max_speed_temperature)
                    {
                        return FAN_MAX_SPEED.fan_max_speed;
                    }
                    else
                    {
                        double max_temperature_difference = (double)(MAX_SPEED_TEMPERATURE.max_speed_temperature - MIN_SPEED_TEMPERATURE.min_speed_temperature);
                        double max_fan_speed_difference = (double)(FAN_MAX_SPEED.fan_max_speed - FAN_MIN_SPEED.fan_min_speed);
                        //
                        double factor = (average_temperature - (double)MIN_SPEED_TEMPERATURE.min_speed_temperature) / max_temperature_difference;
                        factor = System.Math.Round(factor, 1);
                        double calculated_speed = (double)FAN_MIN_SPEED.fan_min_speed + max_fan_speed_difference * factor;
                        //
                        double max_fan_speed_difference_step = max_fan_speed_difference / (double)fan_step_resolution;
                        double calculated_speed_steps = calculated_speed / max_fan_speed_difference_step;
                        calculated_speed_steps = System.Math.Round(calculated_speed_steps, 0);
                        //
                        double calculated_speed_rounded = max_fan_speed_difference_step * calculated_speed_steps;
                        //
                        return (int)calculated_speed_rounded;
                    }
                }
            }
            //
            #endregion

            #region set_fan_speed_smc()
            //
            private static void set_fan_speed_smc(ushort speed)
            {
                ushort smc_speed = AppleSMC.decode_speed(speed);
                AppleSMC.write_UInt16_safe(AppleSMC.dKeys.FAN_TARGET_SPEED_1, smc_speed);
                AppleSMC.write_UInt16_safe(AppleSMC.dKeys.FAN_TARGET_SPEED_0, smc_speed);
            }
            //
            #endregion

            //  -   -   -

            #region enable_custom_fan_control()
            //
            private static bool enable_custom_fan_control()
            {
                ushort value = 0;
                if (AppleSMC.read_UInt16_safe(AppleSMC.dKeys.FANS_MANUAL, ref value) == true)
                {
                    value = (ushort)(value | smc_fan_bits);         // set only the fan bits to one (the other bits remain unchanged)
                    return AppleSMC.write_UInt16_safe(AppleSMC.dKeys.FANS_MANUAL, value);
                }
                else
                {
                    return false;
                }
            }
            //
            #endregion

            #region disable_custom_fan_control()
            //
            private static bool disable_custom_fan_control()
            {
                ushort value = 0;
                if (AppleSMC.read_UInt16_safe(AppleSMC.dKeys.FANS_MANUAL, ref value) == true)
                {
                    value = (ushort)(value & ~smc_fan_bits);        // reset only the fan bits to zero (the other bits remain unchanged)
                    return AppleSMC.write_UInt16_safe(AppleSMC.dKeys.FANS_MANUAL, value);
                }
                else
                {
                    return false;
                }
            }
            //
            #endregion
        }
        //
        #endregion

        //  -   -   -

        #region Apple System Management Controller (SMC) : class AppleSMC
        //
        internal static class AppleSMC
        {
            #region AppleSMC default keys : class dKeys
            //
            //  This keys are on all MacBookPro models the same
            //
            public static class dKeys
            {
                public const string AVERANGE_AMBIENT_LIGHT = "ALSL";                    // (2 Bytes, ui16, read-only)  =  Average ALS Ambient Light Reading in Lux
                public const string MOTION_SENSOR_CONTROL_REGISTER = "MOCN";            // (2 Bytes, ui16, read-write) =  Motion sensor (SMS) Control register - enables accelerometer and threshold testing
                public const string MOTION_SENSOR_X = "MO_X";                           // (2 Bytes, ui16, read-only)  =  Motion sensor X value
                public const string MOTION_SENSOR_Y = "MO_Y";                           // (2 Bytes, ui16, read-only)  =  Motion sensor Y value
                public const string MOTION_SENSOR_Z = "MO_Z";                           // (2 Bytes, ui16, read-only)  =  Motion sensor Z value
                public const string CPU_CORE_CURRENT = "IC0C";                          // (2 Bytes, fp79, read-only)  =  CPU core current consumption in mA
                public const string CPU_CORE_POWER = "PC0C";                            // (2 Bytes, fp88, read-only)  =  CPU core power consumption in W
                public const string POWER_SUPPLY_CURRENT = "ID0R";                      // (2 Bytes, fp5b, read-only)  =  Power supply current consumption in mA
                public const string POWER_SUPPLY_POWER = "PD0R";                        // (2 Bytes, fp88, read-only)  =  Power supply power consumption in W
                //
                public const string FANS_COUNT = "FNum";                                // (1 Byte,  ui8,  read-only)  =  Number of supported fans
                public const string FANS_MANUAL = "FS! ";                               // (2 Bytes, ui16, read-write) =  Fan force bits. FS![15:0] Setting bit to 1 allows for external control over fan speed target and prevents thermal manager from actively overidding value set via key access.
                //
                public const string FAN_ACTUAL_SPEED_0 = "F0Ac";                        // (2 Bytes, fpe2, read-only)  =  Fan0 Actual Speed
                public const string FAN_MIN_SPEED_0 = "F0Mn";                           // (2 Bytes, fpe2, read-only)  =  Fan0 Minimum Speed
                public const string FAN_MAX_SPEED_0 = "F0Mx";                           // (2 Bytes, fpe2, read-only)  =  Fan0 Maximum Speed
                public const string FAN_SAFE_SPEED_0 = "F0Sf";                          // (2 Bytes, fpe2, read-only)  =  Fan0 Safe Speed
                public const string FAN_TARGET_SPEED_0 = "F0Tg";                        // (2 Bytes, fpe2, read-write) =  Fan0 Target Speed. Modify this in conjunction with Fan force bit [0] to set fan speed.
                public const string FAN_POSITION_0 = "F0ID";                            // (16 bytes, txt, read-write) =  Fan0 Description
                //
                public const string FAN_ACTUAL_SPEED_1 = "F1Ac";                        // (2 Bytes, fpe2, read-only)  =  Fan1 Actual Speed
                public const string FAN_MIN_SPEED_1 = "F1Mn";                           // (2 Bytes, fpe2, read-only)  =  Fan1 Minimum Speed
                public const string FAN_MAX_SPEED_1 = "F1Mx";                           // (2 Bytes, fpe2, read-only)  =  Fan1 Maximum Speed
                public const string FAN_SAFE_SPEED_1 = "F1Sf";                          // (2 Bytes, fpe2, read-only)  =  Fan1 Safe Speed
                public const string FAN_TARGET_SPEED_1 = "F1Tg";                        // (2 Bytes, fpe2, read-write) =  Fan1 Target Speed. Modify this in conjunction with Fan force bit [0] to set fan speed.
                public const string FAN_POSITION_1 = "F1ID";                            // (16 bytes, txt, read-write) =  Fan1 Description
                //
                public const string FAN_ACTUAL_SPEED_2 = "F2Ac";                        // (2 Bytes, fpe2, read-only)  =  Fan2 Actual Speed
                public const string FAN_MIN_SPEED_2 = "F2Mn";                           // (2 Bytes, fpe2, read-only)  =  Fan2 Minimum Speed
                public const string FAN_MAX_SPEED_2 = "F2Mx";                           // (2 Bytes, fpe2, read-only)  =  Fan2 Maximum Speed
                public const string FAN_SAFE_SPEED_2 = "F2Sf";                          // (2 Bytes, fpe2, read-only)  =  Fan2 Safe Speed
                public const string FAN_TARGET_SPEED_2 = "F2Tg";                        // (2 Bytes, fpe2, read-write) =  Fan2 Target Speed. Modify this in conjunction with Fan force bit [0] to set fan speed.
                public const string FAN_POSITION_2 = "F2ID";                            // (16 bytes, txt, read-write) =  Fan2 Description
                //
                public const string FAN_ACTUAL_SPEED_3 = "F3Ac";                        // (2 Bytes, fpe2, read-only)  =  Fan3 Actual Speed
                public const string FAN_MIN_SPEED_3 = "F3Mn";                           // (2 Bytes, fpe2, read-only)  =  Fan3 Minimum Speed
                public const string FAN_MAX_SPEED_3 = "F3Mx";                           // (2 Bytes, fpe2, read-only)  =  Fan3 Maximum Speed
                public const string FAN_SAFE_SPEED_3 = "F3Sf";                          // (2 Bytes, fpe2, read-only)  =  Fan3 Safe Speed
                public const string FAN_TARGET_SPEED_3 = "F3Tg";                        // (2 Bytes, fpe2, read-write) =  Fan3 Target Speed. Modify this in conjunction with Fan force bit [0] to set fan speed.
                public const string FAN_POSITION_3 = "F3ID";                            // (16 bytes, txt, read-write) =  Fan3 Description
            }
            //
            #endregion

            #region  AppleSMC interface keys : class iKeys
            //
            //  This keys changes from MacBookPro model to MacBookPro model
            //
            public static InterfaceKeys iKeys;                                          // iKeys must be initialized with a MacBookPro model class or the MacBookPro base class will not work
            public abstract class InterfaceKeys
            {
                public abstract string CPU_TEMP { get; }                                // (2 Bytes, sp78) = CPU die temperature
                public abstract string CPU_PROXIMITY_TEMP { get; }                      // (2 Bytes, sp78) = CPU proximity temperature
                public abstract string GPU_TEMP { get; }                                // (2 Bytes, sp78) = GPU 0 die temperature
                public abstract string GPU_PROXIMITY_TEMP { get; }                      // (2 Bytes, sp78) = GPU 0 proximity temperature
                public abstract string MAINBOARD_TEMP_01 { get; }                       // (2 Bytes, sp78) = Mainboard temperature 1
                public abstract string MAINBOARD_TEMP_02 { get; }                       // (2 Bytes, sp78) = Mainboard temperature 2
                public abstract string MEMORY_TEMP { get; }                             // (2 Bytes, sp78) = Memory temperature
                public abstract string PCIE_SLOT_TEMP { get; }                          // (2 Bytes, sp78) = PCI Express Slot temperature
                public abstract string HEATSINK_TEMP { get; }                           // (2 Bytes, sp78) = Heatsink temperature
                public abstract string CASE_TEMP_01 { get; }                            // (2 Bytes, sp78) = Case temperature 1
                public abstract string CASE_TEMP_02 { get; }                            // (2 Bytes, sp78) = Case temperature 2
            }
            //
            #endregion

            //  -   -   -

            #region read_Int32(), read_UInt32()
            //
            public static bool read_Int32(string key, ref int value, ref int smc_result)
            {
                smc_result = -1;                                        // invalid SMC result
                if (key.Length != 4)
                {
                    return false;
                }
                else
                {
                    int ikey = AppleSMC.string2int(key);                // init the SMC KEY to read as integer
                    int[] inArg = new int[] { ikey, 4 };                // set as input argument the SMC KEY and the Data Size (count = 2)
                    int[] outArg = new int[2];                          // int the output arguments (count = 2)
                    bool result = ACPI.METHOD.Call("SMCR", inArg, inArg.Length, ref outArg, outArg.Length);             // read with the SMCR ACPI nhcMethod values from AppleSMC
                    if (result == true)
                    {
                        smc_result = outArg[0];                         // SMCR result status
                        if (smc_result == 0)                            // 0 -> OK
                        {
                            value = outArg[1];                          // SMCR result value
                        }
                    }
                    return result;
                }
            }
            //
            public static bool read_UInt32(string key, ref uint value, ref int smc_result)
            {
                int ivalue = (int)value;
                if (read_Int32(key, ref ivalue, ref smc_result) == true)
                {
                    value = (uint)ivalue;
                    return true;
                }
                else
                {
                    return false;
                }
            }
            //
            #endregion
            #region read_Int32_safe(), read_UInt32_safe()
            //
            public static bool read_Int32_safe(string key, ref int value)
            {
                // Some times a call to the Apple SMC fails because another software use it.
                // This function will try again until 10 times and will wait also with different time intervals (total maximum wait time is 90ms)
                //
                int smc_result = -1;                                    // invalid SMC result
                for (int i = 0; i < 10; i++)                            // retry until 10 times to get the value
                {
                    if (read_Int32(key, ref value, ref smc_result) == false)
                    {
                        return false;                                   // ERROR on calling the acpi method
                    }
                    else if (smc_result == 0)
                    {
                        return true;                                    // OK - SMC Result valid
                    }
                    else
                    {
                        System.Threading.Thread.Sleep(i * 2);           // Error from Apple SMC -> Wait a short period of time and then try again
                    }
                }
                return false;
            }
            //
            public static bool read_UInt32_safe(string key, ref uint value)
            {
                int ivalue = (int)value;
                if (read_Int32_safe(key, ref ivalue) == true)
                {
                    value = (uint)ivalue;
                    return true;
                }
                else
                {
                    return false;
                }
            }

            //
            #endregion

            #region read_Int16(), read_UInt16
            //
            public static bool read_Int16(string key, ref short value, ref int smc_result)
            {
                smc_result = -1;                                        // invalid SMC result
                if (key.Length != 4)
                {
                    return false;
                }
                else
                {
                    int ikey = AppleSMC.string2int(key);                // init the SMC KEY to read as integer
                    int[] inArg = new int[] { ikey, 2 };                // set as input argument the SMC KEY and the Data Size (count = 2)
                    int[] outArg = new int[2];                          // int the output arguments (count = 2)
                    bool result = ACPI.METHOD.Call("SMCR", inArg, inArg.Length, ref outArg, outArg.Length);             // read with the SMCR ACPI nhcMethod values from AppleSMC
                    if (result == true)
                    {
                        smc_result = outArg[0];                         // SMCR result status
                        if (smc_result == 0)                            // 0 -> OK
                        {
                            value = (short)outArg[1];                   // SMCR result value
                        }
                    }
                    return result;
                }
            }
            public static bool read_UInt16(string key, ref ushort value, ref int smc_result)
            {
                short ivalue = (short)value;
                if (read_Int16(key, ref ivalue, ref smc_result) == true)
                {
                    value = (ushort)ivalue;
                    return true;
                }
                else
                {
                    return false;
                }
            }
            //
            #endregion
            #region read_Int16_safe(), read_UInt16_safe()
            //
            public static bool read_Int16_safe(string key, ref short value)
            {
                // Some times a call to the Apple SMC fails because another software use it.
                // This function will try again until 10 times and will wait also with different time intervals (total maximum wait time is 90ms)
                //
                int smc_result = -1;                                    // invalid SMC result
                for (int i = 0; i < 10; i++)                            // retry until 10 times to get the value
                {
                    if (read_Int16(key, ref value, ref smc_result) == false)
                    {
                        return false;                                   // ERROR on calling the acpi method
                    }
                    else if (smc_result == 0)
                    {
                        return true;                                    // OK - SMC Result valid
                    }
                    else
                    {
                        System.Threading.Thread.Sleep(i * 2);           // Error from Apple SMC -> Wait a short period of time and then try again
                    }
                }
                return false;
            }
            //
            public static bool read_UInt16_safe(string key, ref ushort value)
            {
                short ivalue = (short)value;
                if (read_Int16_safe(key, ref ivalue) == true)
                {
                    value = (ushort)ivalue;
                    return true;
                }
                else
                {
                    return false;
                }
            }
            //
            #endregion

            #region write_Int16(), write_UInt16
            //
            public static bool write_Int16(string key, short value, ref int smc_result)
            {
                smc_result = -1;                                        // invalid SMC result
                if (key.Length != 4)
                {
                    return false;
                }
                else
                {
                    int ikey = AppleSMC.string2int(key);                // init the SMC KEY to read as integer
                    int[] inArg = new int[] { ikey, value, 2 };         // set as input argument the SMC KEY, Value and the Data Size (count = 3)
                    int[] outArg = new int[1];                          // int the output argument (count = 1)
                    bool result = ACPI.METHOD.Call("SMCW", inArg, inArg.Length, ref outArg, outArg.Length);             // write with the SMCW ACPI nhcMethod values to the AppleSMC
                    if (result == true)
                    {
                        smc_result = outArg[0];                         // SMCR result status
                    }
                    return result;
                }
            }
            public static bool write_UInt16(string key, ushort value, ref int smc_result)
            {
                return write_Int16(key, (short)value, ref smc_result);
            }
            //
            #endregion
            #region write_Int16_safe(), write_UInt16_safe()
            //
            public static bool write_Int16_safe(string key, short value)
            {
                // Some times a call to the Apple SMC fails because another software use it.
                // This function will try again until 10 times and will wait also with different time intervals (total maximum wait time is 90ms)
                //
                int smc_result = -1;                                    // invalid SMC result
                for (int i = 0; i < 10; i++)                            // retry until 10 times to get the value
                {
                    if (write_Int16(key, value, ref smc_result) == false)
                    {
                        return false;                                   // ERROR on calling the acpi method
                    }
                    else if (smc_result == 0)
                    {
                        return true;                                    // OK - SMC Result valid
                    }
                    else
                    {
                        System.Threading.Thread.Sleep(i * 2);           // Error from Apple SMC -> Wait a short period of time and then try again
                    }
                }
                return false;
            }
            //
            public static bool write_UInt16_safe(string key, ushort value)
            {
                return write_Int16_safe(key, (short)value);
            }
            //
            #endregion

            #region read_byte()
            //
            public static bool read_byte(string key, ref byte value, ref int smc_result)
            {
                smc_result = -1;                                        // invalid SMC result
                if (key.Length != 4)
                {
                    return false;
                }
                else
                {
                    int ikey = AppleSMC.string2int(key);                // init the SMC KEY to read as integer
                    int[] inArg = new int[] { ikey, 1 };                // set as input argument the SMC KEY and the Data Size (count = 2)
                    int[] outArg = new int[2];                          // int the output arguments (count = 2)
                    bool result = ACPI.METHOD.Call("SMCR", inArg, inArg.Length, ref outArg, outArg.Length);             // read with the SMCR ACPI nhcMethod values from AppleSMC
                    if (result == true)
                    {
                        smc_result = outArg[0];                         // SMCR result status
                        if (smc_result == 0)                            // 0 -> OK
                        {
                            value = (byte)outArg[1];                    // SMCR result value
                        }
                    }
                    return result;
                }
            }
            //
            #endregion
            #region read_byte_safe()
            //
            public static bool read_byte_safe(string key, ref byte value)
            {
                // Some times a call to the Apple SMC fails because another software use it.
                // This function will try again until 10 times and will wait also with different time intervals (total maximum wait time is 90ms)
                //
                int smc_result = -1;                                    // invalid SMC result
                for (int i = 0; i < 10; i++)                            // retry until 10 times to get the value
                {
                    if (read_byte(key, ref value, ref smc_result) == false)
                    {
                        return false;                                   // ERROR on calling the acpi method
                    }
                    else if (smc_result == 0)
                    {
                        return true;                                    // OK - SMC Result valid
                    }
                    else
                    {
                        System.Threading.Thread.Sleep(i * 2);           // Error from Apple SMC -> Wait a short period of time and then try again
                    }
                }
                return false;
            }
            //
            #endregion

            #region read_string()
            //
            public static bool read_string(string key, ref string text, ref int smc_result)
            {
                smc_result = -1;                                        // invalid SMC result
                if (key.Length != 4)
                {
                    return false;
                }
                else
                {
                    int ikey = AppleSMC.string2int(key);                // init the SMC KEY to read as integer
                    int[] inArg = new int[] { ikey };                   // set as input argument the SMC KEY
                    int[] outArg = new int[5];                          // int the output arguments (count = 5) -> result + byte[16]
                    bool result = ACPI.METHOD.Call("SR16", inArg, inArg.Length, ref outArg, outArg.Length);             // read with the SR16 ACPI nhcMethod the 16 bytes from AppleSMC
                    if (result == true)
                    {
                        smc_result = outArg[0];                         // SMCR result status
                        if (smc_result == 0)                            // 0 -> OK
                        {
                            #region convert outArg to text string
                            //
                            char[] char_array = new char[16];
                            for (int i = 0; i < 16; i = i + 1)
                            {
                                int pos = i / 4;                        // get index for the outArg[]
                                int shift = (i % 4) * 8;                // get shift amount (0, 8, 16 or 24)
                                byte b = (byte)(outArg[pos] >> shift);  // get byte from outArg[pos]
                                if ((b < 0x20) || (b > 0x7E))           // convert NO ASCII character to space character
                                {
                                    b = 0x20;
                                }
                                char_array[i] = (char)b;
                            }
                            text = new string(char_array);              // convert byte array to string
                            text = text.Trim();                         // remove all leading and trailing white-space characters
                            //
                            #endregion
                        }
                    }
                    return result;
                }
            }
            //
            #endregion
            #region read_string_safe()
            //
            public static bool read_string_safe(string key, ref string text)
            {
                // Some times a call to the Apple SMC fails because another software use it.
                // This function will try again until 10 times and will wait also with different time intervals (total maximum wait time is 90ms)
                //
                int smc_result = -1;                                    // invalid SMC result
                for (int i = 0; i < 10; i++)                            // retry until 10 times to get the value
                {
                    if (read_string(key, ref text, ref smc_result) == false)
                    {
                        return false;                                   // ERROR on calling the acpi method
                    }
                    else if (smc_result == 0)
                    {
                        return true;                                    // OK - SMC Result valid
                    }
                    else
                    {
                        System.Threading.Thread.Sleep(i * 2);           // Error from Apple SMC -> Wait a short period of time and then try again
                    }
                }
                return false;
            }
            //
            #endregion

            //  -   -   -

            #region int2string()
            //
            public static string int2string(int value)
            {
                char[] carray = new char[] { (char)(value & 0xFF), (char)((value >> 8) & 0xFF), (char)((value >> 16) & 0xFF), (char)((value >> 24) & 0xFF) };
                return new string(carray);
            }
            //
            #endregion
            #region string2int()
            //
            public static int string2int(string value)
            {
                int max_length = value.Length;
                if (max_length > 4)
                {
                    max_length = 4;
                }
                int result = 0;
                for (int i = 0; i < max_length; i++)
                {
                    result = result | (value[i] << (i * 8));
                }
                return result;
            }
            //
            #endregion

            #region endian_swap2byte()
            //
            public static short endian_swap2byte(short value)
            {
                return (short)endian_swap2byte((ushort)value);
            }
            public static ushort endian_swap2byte(ushort uvalue)
            {
                uint swapped = (((uint)uvalue & 0x00FF) << 8) |
                               (((uint)uvalue & 0xFF00) >> 8);
                return (ushort)swapped;
            }
            //
            #endregion
            #region endian_swap4byte()
            //
            public static int endian_swap4byte(int value)
            {
                return (int)endian_swap4byte((uint)value);
            }
            public static uint endian_swap4byte(uint uvalue)
            {
                uint swapped = ((uvalue & 0x000000FF) << 24) |
                               ((uvalue & 0x0000FF00) << 8) |
                               ((uvalue & 0x00FF0000) >> 8) |
                               ((uvalue & 0xFF000000) >> 24);
                return swapped;
            }
            //
            #endregion

            //  -   -   -

            #region encode_temperature()
            //
            public static double encode_temperature(ushort uvalue)
            {
                byte a = (byte)(uvalue);
                byte b = (byte)(uvalue >> 14);
                double dvalue = (double)a + (double)b * 0.25;
                return dvalue;
            }
            //
            #endregion

            #region encode_speed()
            //
            public static ushort encode_speed(ushort uvalue)
            {
                return (ushort)(endian_swap2byte(uvalue) / 2);
            }
            //
            #endregion
            #region decode_speed()
            //
            public static ushort decode_speed(ushort uvalue)
            {
                return endian_swap2byte((ushort)(uvalue * 2));
            }
            //
            #endregion
        }
        //
        #endregion

        //  -   -   -

        #region Notebook Hardware Control - Custom Data : class nhcData
        //
        //  NHC will save in this class data for additional features.
        //  Please do not modify or remove this class unless you know what you are doing.
        //
        //  Note: This class is not visible in the ACPI Control System.
        //        The source code of the nhcMethods is compressed and can be decompressed with the tool 'nhcMethod Decompressor'
        //         >> Location of the tool: NHC -> ACPI -> Hardware -> 'Acpi Object Explorer' -> 'nhcMethod Editor' -> Tools -> 'Show the nhcMethod Decompressor'
        //
        public static class nhcData
        {
            public static class nhcMethod
            {
                public static class SMCR
                {
                    public static string SourceCode="RQ4AAB+LCAAAAAAABADtvQdgHEmWJSYvbcp7f0r1StfgdKEIgGATJNiQQBDswYjN5pLsHWlHIymrKoHKZVZlXWYWQMztnbz33nvvvffee++997o7nU4n99//P1xmZAFs9s5K2smeIYCqyB8/fnwfPyK+yNt5NUu3Xn9x8mqU7o3SF1X7Oq+LrCx+kM/upN3n7t30VZ7N0lnWZul5XS3Sdp6nx6tVmaevr5s2X6RfZMvsIl/kyzY9qZZtXZVlXnMPd37j5Bf3IG5+qL/Pvv7zGyc3dtB5qL/j+mIn/cyM6YuT9PfKr78uoF0C9BSkep4vL9p5urWbtlW6f+drwdsefr4WvFd5sy5bjLXm39Kmzdp1k27hoy9/r6+HpADddUAvs3Kd/8aJAKMGO+P0aX5eLIu2qJbpeVUzB53d/TJ9WdVtmk2nedOk1bnPWF+cmNfl55ervM7w/qv8gv4Fbz0bKf+dfTlKd97d29nBj51dHcWzIi9n2u7JdZsfT6fg9efV9O0ofUmo5vVlrm1/sRs4vfB0lB6M+kMNHxoXTzMPYd3ks3Ry3UX+l3hE2A2IoINVgq2y6VsSoHDEL7JFnm69On39+xO60oDm6d3OXh/nnXfP9NmMNqHRmfft3Tvp9lEq0+8D3NnZAMc+DqDOOT78JXe8Ye+N09f5cqajJTUyrRaLDB9U/Flvol+3VZ1vfffki6c02N2dO6OUZiwrd/qKieE3AB4Altd68M/Ot56f/qJ1Vm4JvFG6eycGU+FO5/n0rZKpzyPAER0p1U9H6dlylr8z07WjkBm/Nj199erLV+nZUyK3mTw8r/J2XS/lnSFMFIpAoInqDbfPaPc8ikc0WkjnHSXv/U0IACoYNy2raiVvf3delPnW8+ckuELP+yPScXEg9DZeTPfTtljkrGxocu712fgLYqRiVV5biAeK3W4ImABm05amMm3mxTkpkEW1JtODwdAbu5+SVfP17Ws0elVczNstKHoDs8dYBPaCZgt0U/ATUhvAFVTvzL7lIuiLwXE3ZiLe5tcWmrKlUx8OtGPS775+cwxp378TY1QCfZXRhNCwi9ICPFEJYJVUNMwnnh3zKI2ny8RPI0zcZ2Azbea5DRP3GBgIByb2l3gkWE5rdiWUCzYABWpKz2X+rhUCr6qGVWxfMPY9wWBnphQLvVkTwaRvmmV5/LnuwGZpjU+7Re3+WHws+zr7WQMYWQ6+SWbPILOin7+WzJ/dLPOgTkzsjcx/5BHjI5H/ntj3mf7+D43pT+JM/zpk+q739o0zvUyMuB7D5k7t7TQvLpVNwPG30J+ffrj+fJ6fq0Qa9vm0iyqBXVSEmWViX+HV0L/phKbPCCiZFN8HqsmvI2eudv1+WYcdGo3d5XsMZ6bxSdDlEOCfPRXz6djwBt6IunWGAwdchhgCX/5egSOiEAxNAjBdqVEIfSftNizsAamluVEmv+T/AVH8S5VFDgAA";
                    public static string AMLCode="025B80534D4346010B0003015B810B534D434601534D434408085245535F120402FF007057434D440A1060A016936001700CFEFFFFFF885245535F0000A45245535F700065A23295650A0477650A08617A6861607060534D4344A01B93575354410A0401700CFDFFFFFF885245535F0000A45245535F75657069534D4344700061700065A235956569A01B93575354410A0501700CFCFFFFFF885245535F0000A45245535F70534D43446077650A0866796066607D60616175657000885245535F00007061885245535F0100A45245535F4C05";
                    public static string DateTimeInfo="12.12.2010-17:14:58";
                }
                public static class SMCW
                {
                    public static string SourceCode="gQsAAB+LCAAAAAAABADtvQdgHEmWJSYvbcp7f0r1StfgdKEIgGATJNiQQBDswYjN5pLsHWlHIymrKoHKZVZlXWYWQMztnbz33nvvvffee++997o7nU4n99//P1xmZAFs9s5K2smeIYCqyB8/fnwfPyK+yNt5NUu3Xn9x8t1Rem+Uvqja13ldZGXxg3x2J+0+d++m362LNk9nWZulbZW28zw9Xq3KPH193bT5Iv0iW2YX+SJftulJtWzrqizzmju48xsnv7gHcPND3X32tZ/fOLkRfueh7o7ri530MzOkL07S3yu//rqAdgnQU6XTFaj2dQHtGUDP8+VFO0+3dgFy/87Xgrc9/HwteK/yZl22IFrNv6VNm7XrJt3CR1/+XoSkgKWmO+P0aX5eLIu2qJbpeVUz+5zd/TJ9WdVtmk2nedOk1bnPVV+cmNfl55ervM7w/qv8gv4FYz0bKfOdfTlKd97d29nBj51dpc+zIi9n2u7JdZsfT6fg8+fV9O0ofUlI5/Vlrm1/sSMBvfB0lB6M+oMOHxoXzw0PYd3ks3Ry3UX+l3hE2B2nr/PljMfIXJFOq8UiwyciTr0hv26rOt/67skXT7d23u3u3hmlhHtW7vTFkztoAD2ELO/1Ojg733p++ovWWbklAEfp7p0YUAU8nefTtzq9PXK9ytt1vURPz+Q5jUMiOKevXn35Kt0+imK6vadT4dNsz6NZRDRDQu0ofe4PDYUfggpGTMuqWsnb350XZb71/DnxoNDj/ohkbHAUeDHdT9tikfep8QUJQrEqry2gA0VqN4RHcLJpSzOQNvPinERgUa1Jc2IM9Mbup6N0zxfz12j0qriYt1tQVAZmjyEI7EXeMrkU/IQYH/MPknvwmGBm8sHxg8NtDP3f5tcWmnKTEwAH2vHWd1+/OSa22Nm/E+MvAn2V0TzQsIvSAjxRdmChKhpSLdnM08MepfH0eC8yjB7foSviIOK4ex6Ff4k3guW0ZkOmk7hBMhoQW8ixzN+1Qp9V1bCi67PzPY+d2ZCWotc3KwAYgk2TJI8/VR3YImnxabO47Y/VwlsAm7GyTHgraRMT8bMlraBQTGCNtH7kEeSjAcn9OeXbk018S82zmczZ1ravFTyeHdQ7n36Desfom09jeofYvybQjn1YFq4KsCB9VANIOiHCGfFIz+tqwe7S19dLtqOfRenFDzthG5lVHnaNuPlrcYi+/L3SLRHBZs2eDhH4l/w/fy9iPoELAAA=";
                    public static string AMLCode="035B80534D4346010B0003015B810B534D434601534D4344087057434D440A1160A00A936001A40CFEFFFFFF700065A22695650A0477650A08617A6861607060534D4344A00F93575354410A0401A40CFDFFFFFF7565706A534D4344700061700065A22595656AA00F93575354410A0401A40CFCFFFFFF77650A08667A6966607060534D43447565A400416F";
                    public static string DateTimeInfo="12.12.2010-17:14:58";
                }
                public static class WCMD
                {
                    public static string SourceCode="egYAAB+LCAAAAAAABADtvQdgHEmWJSYvbcp7f0r1StfgdKEIgGATJNiQQBDswYjN5pLsHWlHIymrKoHKZVZlXWYWQMztnbz33nvvvffee++997o7nU4n99//P1xmZAFs9s5K2smeIYCqyB8/fnwfPyK+yNt5NUu3vnvyxdNRujtKX1Tt67wusrL4QT67k3afu3fT1/lylk6rxSKjn22VtvM8ff3FSYo/r7KiTc+rmj+s82x2nTZt1q6b3zj5xT1Ymx/q6bOv8/zGyY2gOw/1dFxf7KSfpSduVA2N8jdOBBg1eJqfF8uiLaqlHd7Z3S/Tl1Xdptl0mjdNWp3zx8erVckEMe/Kzy9XeZ3h/Vf5Bf27RQ2ejdLX102bL86+HKU77+7t7OPHzu4deeNZkZczbffkus2Pp1NMz/Nq+naUvqzzJq8vc237i92o6YWTUXrQG2X3oUHpcO++5imSwaybfJZOrrvD+CUeLV6v8ikxSNrSBLeLfNli6IYhVgCynRKdlvlVXqeLbDqpqrfNKCXOaPJ80dAXoFdWX1uIRG+MB5QnChpQExp0OsmJ3jmBLctiecHfC0el2UVWLMchlV+31Hhr593+ziglQmXl/T4Lm4f6JUh1e3dBM7tYL4R522KREyd8uk89bB2/fPn8lGjw+39x9uL3/+7x2Rv6BsCV6t+dF2W+9fw5jWZLesMEHuzs7NzpdUu9Mfz1CqO9t0d0MIyk42HKeV0e/96uS4bZn2oeLXh3xNM+NFaMlIh7V2kMuYwIsIP7XfpLBzRMvtSNaYupRaNZED6KJh7BTxiSwe3EwREcxglaJOAjoztMw+PlTPDaYUl5NgSWAC6y5q0PJL3MynXuQJ2dbz0//UXrrPQBnkTnbTrPp29vRs6bGDyv8nZdL9OtgTHzIywI7GqSieKSRG8LiNPPq6KdA6XzOyRNbV4Tk2YkDmVVrVw/v8T9elo23ug6uLyeF+ft8/y8tWy625MPwqVYTuucBdqKQq8v/WFGt7uRQeQhyKevXn35igby5uyL0/TLr978xskv+X8AOHlFGXoGAAA=";
                    public static string AMLCode="015B80534D4346010B0403015B810B534D434601534D434308700A4065A22A95650B00807068534D434357534D436570534D4343607B600A0F60A00793600A0CA400A10579650165A4019811";
                    public static string DateTimeInfo="12.12.2010-17:14:58";
                }
                public static class WSTA
                {
                    public static string SourceCode="BwYAAB+LCAAAAAAABADtvQdgHEmWJSYvbcp7f0r1StfgdKEIgGATJNiQQBDswYjN5pLsHWlHIymrKoHKZVZlXWYWQMztnbz33nvvvffee++997o7nU4n99//P1xmZAFs9s5K2smeIYCqyB8/fnwfPyK+yNt5NUu3vvv6zfEo3R2lL6r2dV4XWVn8IJ/dSbvP3bvpd7OiTV+3Wbtu0u30Cn+dV3XazvO0kU9XVd2mbZVe5G2apdO8brNimV5m5Tr/jZNf3IO5+aEeP/uQ5zdObuyi81CPx/XFTvqZjvI3TgQGff40Py+WRVtUSzvms7tfpi8x4Gw6zZsmrc754+PVqszT11+cmHfl55ervM7w/qv8gv7dogbPRunr66bNF2dfjtKdd/d29vFjZ/eOvPGsyMuZtnty3ebH0ylm6Xk1fTtKX9Z5k9eXubb9xW6w9MLJKD3oDa770KBOqsUiW87u6pzyYNZNPksn191h/BKPFswH6xUm+t7eonkvJlAQW4useUsdXRXtHGM+vzNK67xd18tieZH+IK+rtBBy8ntpQeSdAE4+G4d0PV7OtjBpTDqiFH7vc68dMvr1cXndVnW+tfNunwAQZbPy/tDL/DoNsW7vLogVFuuFiEBbLHLimE/3aehbxy9fPj8lov3+X5y9+P2/e3z2hr4BcJ2m786LMt96/pzYZUt6A9oHOzs7d/oT+V2Co62GcUoZLUZki1GguVjQkBQcHhmisAWDG6APwanzbIY5T6fCGTKXjQqDaQiSCyBD9DhYQ24PiE96PGfnW89Pf9E6Ky1Anr8eggRqOs+nb29GziMgnlfMVOnWIE+kZl6BXZ1P8+KS+LLPn6Tx2rymmc/aPC2rauX6+SXu19Oy8UbXweX1vDhvn+fnrZ373R7TES7Fclrni3zZOv7q9aU/zOh2NzKIPAT59NWrL1/RQN6cfXGafvnVm984+SX/D4Ak6ysHBgAA";
                    public static string AMLCode="015B80534D4346010B0403015B810B534D434601534D4343087B680A0F68700A4065A22395650B008057534D436570534D4343607B600A0F60A006936068A400A10579650165A4017864";
                    public static string DateTimeInfo="12.12.2010-17:14:58";
                }
                public static class WSMC
                {
                    public static string SourceCode="qwMAAB+LCAAAAAAABADtvQdgHEmWJSYvbcp7f0r1StfgdKEIgGATJNiQQBDswYjN5pLsHWlHIymrKoHKZVZlXWYWQMztnbz33nvvvffee++997o7nU4n99//P1xmZAFs9s5K2smeIYCqyB8/fnwfPyK+yNt5NUu3vvv6i5NRujtKX1Tt67wusrL4QT67k3afu3fT72ZFm55XdUqvpNvpLC+z63QhcPBxO8/5q2w6zZvmN05+cQ/I5oe6+Ow9n984uRFq56FOjuuLnfQzxb8tFnlaLNNFMa2rJp9WyxmhLnCp7TMa12VeX6fNvKpbeadJt3bTtkp3d3aC1+6kV3m6WDdtum6IEm1WlmML6A0Rp86bqly3RbVMq/O0KfN8lRZNuqxa0GxdZ22e5stqfTFvx9yzdldWy4sc9M2WvU7DPgHS9ik/z863nj+n+Tj9Reus3MLYRwBy5458/YsdCRljbtGffv+h0VBnU8FOXv8l8uO0bPIe2KfFZTHLXc+j9Hk1zcpd/Wk7I7DNqiQWAx+5yXGAvjsvynzr+ed1ToSqt+TtUWqH0ukXjwwJw/U/DZ/IcMzzNJ/W+SJfttqZ15GOGI90IoPaRDnqiKasIWLUaVY2FQ+U4GfFEh8RS/DIiVwNsYgl7C/5fwDfWqhQqwMAAA==";
                    public static string AMLCode="01A0099294680A645B2168A11578680A646160A20A9460005B210A6476605B2161F076";
                    public static string DateTimeInfo="12.12.2010-17:14:58";
                }
                public static class SR16
                {
                    public static string SourceCode="nRAAAB+LCAAAAAAABADtvQdgHEmWJSYvbcp7f0r1StfgdKEIgGATJNiQQBDswYjN5pLsHWlHIymrKoHKZVZlXWYWQMztnbz33nvvvffee++997o7nU4n99//P1xmZAFs9s5K2smeIYCqyB8/fnwfPyK+yNt5NUu3Xr/a/XSU7o7SF1X7Oq+LrCx+kM/upN3n7t30VZ7N0jZ/16bndbVI23meHq9WZZ6+vm7afJF+kS2zi3yRL9v0pFq2dVWWeU09fHFy5zdOfnEP4uaH+vvs6z+/cXJjB52H+juuL3bSz8yYvjhJf6/8+msB2h5+vha8V3mzLlvgVvNvadNm7bpJt/DRl7/XnQ8Auptu62/7BIsnd2s6z+rv7X76fYIrkKn1zjh9mp8Xy6ItqmV6XtU8/Wd3v0xfVnWbZtNp3jRpde5zxRcn5nX5+eUqrzO8/yq/oH/BGM9GyjxnX47SnXf3dnbwY2dXh/SsyMuZtnty3ebH0ykY9Xk1fTtKXxIx8voy17a/2FGBXng6Sg9G/XGHD43radZmMoR1k8/SyXUX+V/iEWE3IIIOVqdklU3fEveHI36RLfJ069Xp69+f0JUGNGnv7vdR3nn3TJ/NWBMWHR7Y3r2Tbh+lwgo+wB19bgtwQgROd7f3PxjG/e2DD4bxcHt374OB7N7b3v1Up9Fn5r1x+jpfznT6SKlNq8UiwwcVf9bj3NdtVedb3z354inN3u7OnVFKLJiVO301yfAbAA8Ay2s9+GfnW89Pf9E6K7cEHiniOzGYCnc6z6dvdeL7TA8c0ZHy0ekoPVvO8neG/3YUMuPXpqevXn35Kj17Sgy05ymQV3m7rpfyzhAmCkUgEOv1htuXnHsexSP6NaTzjpL3/iYEABWSmJZVtZK3vzsvynzr+XPSRELP+6N0f4Ce9DZeTPfTtljkfWp+QUxUrMprC+hAkdoN4RGcbNrSDKbNvDgnRbio1mT/MAZ6A6Z1b98j72s0elVczNstWBsDs8dPBPaCJgnkUvDM0MQ/IHZn0i3zQO8NDrcx9H+bX1toyo1ODTrQjje/+/rNMfHVzv6dGH8S6KuM5oGGXZQW4IkyPqvWomH28IypR2k8Xd59GuHdPt/e6xi+2/Buj2+BcGDnf4lHguW0Zn9GuWADUKCm9FzCiDKBV1XDpqIvD/uePMxA+zJfXrTzGxQQ2Gl4juXxZ7oDmUU0PukWsftjMrqlzKOatPSqoPcBa5OwPrhJWM8grD5YnuEByX2wUXKfe5ILJ4jGZHjBYyxq+OlYnVZDDHZcLXWlVVearFTeakRib4Zg3KjCGIYZilNleD5AnXWIgqcjcX3pvv/NSTeeTn94ulJ+Epfy16GU++rTPN+MpOPxpB2PzJ74j8MmXh2NaV5cKl9B3ENIgwbk0w8yIHjYiDzPz1UtGV77tIsygV5UhKHlfl/r1zBC6YSm1mgpMqe+Q1uTk06eeR32/WVtOlXLNSAqGNZsFul2E3BfFvF8s/oXj9XB+tqDsXKlzqZirJQIfHp5Y9A4DOo/5WgfuS7Fe/2opBjnIJAS7e2OB1uJepmV6zwK0zc9B2MjPr1mgWZnFox6kN3hgfZf/l6BX3obAfUg1NLc6NJf8v8AMueA650QAAA=";
                    public static string AMLCode="015B80534D4346010B0003015B810B534D434601534D434408085245535F120705FF000000007057434D440A1060A016936001700CFEFFFFFF885245535F0000A45245535F700065A23295650A0477650A08617A6861607060534D4344A01B93575354410A0401700CFDFFFFFF885245535F0000A45245535F7565700A10534D4344700067A24E0495670A04700061700065A23695650A04A01B93575354410A0501700CFCFFFFFF885245535F0000A45245535F70534D43446077650A0866796066607D606161756575677061885245535F67007000885245535F0000A45245535F2E72";
                    public static string DateTimeInfo="12.12.2010-17:14:58";
                }
            }
        }
        //
        #endregion
    }
    //
    #endregion

}

